<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';


try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;

    $query = "SELECT * FROM users WHERE `user_id` = '$userId'";

    $result = mysqli_query($conn, $query);

    if (!$result) {
        throw new Exception('Error executing query: ' . mysqli_error($conn));
    }

    $row_count = mysqli_num_rows($result);

    if ($row_count === 1) {
        $client_data = mysqli_fetch_assoc($result);

        $client_role = $client_data["role_id"];

        $role_query = "SELECT * FROM user_role WHERE `id` = '$client_role' AND `active_status` = 1";

        $role_result = mysqli_query($conn, $role_query);

        if (mysqli_num_rows($role_result) < 1) {
            // Handle the case where the role query is not successful
            $response = array('success' => false, 'message' => 'Contact admin');
            echo json_encode($response);
        } else {
            $role_data = mysqli_fetch_assoc($role_result);
            $role_role = json_decode($role_data["privilege"]);
            $role_data["privilege"] = $role_role;

            $response = array('success' => true, 'role' => $role_data, 'message' => 'Authentication successful');
            echo json_encode($response);
        }

    } else {
        // Authentication failed
        $response = array('success' => false, 'message' => 'Invalid user id');
        echo json_encode($response);
    }

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>