<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("notification/client_notification.php");
include("sendemail/sendMail.php");
include("allmails/allMail.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $adminId = isset($_POST['adminId']) ? mysqli_real_escape_string($conn, $_POST['adminId']) : null;
    $reference = isset($_POST['reference']) ? mysqli_real_escape_string($conn, $_POST['reference']) : null;
    $cid = isset($_POST['cid']) ? mysqli_real_escape_string($conn, $_POST['cid']) : null;


    // Check if reference no already exists
    $referenceCheckQuery = "SELECT * FROM invoice_details WHERE reference_number = '$reference'";
    $referenceCheckResult = mysqli_query($conn, $referenceCheckQuery);

    if (mysqli_num_rows($referenceCheckResult) > 0) {
        throw new Exception('Reference NO is already available');
    }


    // File handling
    if (isset($_FILES['file'])) {

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "http://file.ozonedesk.info/upload.php");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt(
            $ch,
            CURLOPT_POSTFIELDS,
            array(
                'file' => new CURLFile($_FILES['file']['tmp_name'], $_FILES['file']['type'], $_FILES['file']['name']),
                'client_id' => 1001,
                'api_key' => 'os-1121',
                'module' => 'upload slip',
                'module_id' => "$id"
            )
        );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $arr = json_decode($result, true);

        $arrstatus = $arr["status"];
        $arrfile_path = $arr["file_path"];
        $arrmodule = $arr["module"];
        $arrmodule_id = $arr["module_id"];

        // Handle the response as needed
        if ($arrstatus == "200" && $arrmodule == "upload slip" && $arrmodule_id == "$id") {
            // Successful upload
            $updateQuery = "UPDATE invoice_details SET `document` = '$arrfile_path' WHERE `invoice_HID` = '$id'";
            $updateResult = mysqli_query($conn, $updateQuery);

            $updaterefQuery = "UPDATE invoice_details SET `reference_number` = '$reference' WHERE `invoice_HID` = '$id'";
            $updaterefResult = mysqli_query($conn, $updaterefQuery);


            if ($updateResult && $updaterefResult) {

                $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$cid'";
                $selectResult = mysqli_query($conn, $selectQuery);

                $row_count = mysqli_num_rows($selectResult);

                if ($row_count === 1) {
                    $client_data = mysqli_fetch_assoc($selectResult);

                    $c_mail = $client_data["email"];
                    $client_name = $client_data["f_name"] . " " . $client_data["l_name"];

                    $query_system = "SELECT * FROM system_setting";

                    $result_system = mysqli_query($conn, $query_system);

                    if (mysqli_num_rows($result_system) > 0) {
                        $row_system = mysqli_fetch_assoc($result_system);
                        //pass row-system to email

                        $mailCont = uploiadSlip($row_system, $client_name, $c_mail, $id, $reference);

                        $postFileds = [
                            'to' => $c_mail, // Recipient's email address
                            'sub' => 'Top-up Slip Uploaded', // Email subject
                            'msg' => $mailCont, // HTML content of the email
                            'from' => 'billing@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
                        ];

                        $sms_details = sendMail($postFileds);

                        $sms_details_array = json_decode($sms_details, true);


                        $response = array('success' => true, 'message' => 'File uploaded successfully');

                        // admin logs
                        $by = $adminId;
                        $date = date('Y-m-d H:i:s');
                        $module = 'Upload slip';
                        $message = "Administrator $adminId has successfully upload the imag for invoice $id.";

                        insertAdminLog($conn, $by, $date, $module, $message);

                        // notification
                        $title = 'Upload Slip';
                        $date = date('Y-m-d H:i:s');
                        $subtitle = "Successfully uploaded a slip for invoice $id";
                        $avatar = 'US';
                        $client_id = $cid;

                        insertNotification($conn, $title, $date, $subtitle, $avatar, $client_id);
                    } else {
                        throw new Exception("system data not found");
                    }
                } else {
                    throw new Exception("client data not found");
                }
            }
        } else {
            // Unsuccessful upload
            $response = array('success' => false, 'message' => 'File upload failed');
        }

       
    } else {
        throw new Exception('File not received');
    }
    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
