<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $adminId = isset($_POST['adminId']) ? mysqli_real_escape_string($conn, $_POST['adminId']) : null;

    // Check if either logo or fav icon is present
    if (isset($_FILES['logo']) || isset($_FILES['fav']) || isset($_FILES['whitelogo'])) {
       
        // File handling for logo
        $logoPath = isset($_FILES['logo']) ? handleFile($_FILES['logo'], 'logo', $adminId) : null;

        // File handling for fav icon
        $favPath = isset($_FILES['fav']) ? handleFile($_FILES['fav'], 'fav', $adminId) : null;

         // File handling for white logo
         $whitelogo = isset($_FILES['whitelogo']) ? handleFile($_FILES['whitelogo'], 'whitelogo', $adminId) : null;

        // Perform database updates and log entries
        if ($logoPath !== false || $favPath !== false || $whitelogo !== false) {
            // Build update query based on available files
            $updateQuery = "UPDATE system_setting SET ";
            if ($logoPath !== null) {
                $updateQuery .= "`logo` = '$logoPath', ";
            }
            if ($favPath !== null) {
                $updateQuery .= "`fav_icon` = '$favPath', ";
            }
            if ($whitelogo!== null) {
                $updateQuery.= "`logo_white_cli` = '$whitelogo', ";
            }
            $updateQuery = rtrim($updateQuery, ", ") . " WHERE `id` = '1'";

            $updateResult = mysqli_query($conn, $updateQuery);

            if ($updateResult) {
                // Log entries for successful upload
                $response = array('success' => true, 'message' => 'Files uploaded successfully');
                
                $by = $adminId;
                $date = date('Y-m-d H:i:s');
                $module = 'Upload files';
                $message = "Administrator $adminId has successfully uploaded the files.";
        
                insertAdminLog($conn, $by, $date, $module, $message);
            } else {
                $response = array('success' => false, 'message' => 'Database update failed');
            }
        } else {
            $response = array('success' => false, 'message' => 'File upload failed');
        }

        echo json_encode($response);
    } else {
        throw new Exception('Either logo or fav icon is required');
    }

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

// Function to handle file upload
function handleFile($file, $moduleName, $adminId)
{
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, "http://file.ozonedesk.info/upload.php");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, array(
        'file' => new CURLFile($file['tmp_name'], $file['type'], $file['name']),
        'client_id' => 1001,
        'api_key' => 'os-1121',
        'module' => $moduleName,
        'module_id' => "$adminId"
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $result = curl_exec($ch);

    curl_close($ch);

    $arr = json_decode($result, true);

    $arrstatus = $arr["status"];
    $arrfile_path = $arr["file_path"];
    $arrmodule = $arr["module"];
    $arrmodule_id = $arr["module_id"];

    // Handle the response as needed
    if ($arrstatus == "200" && $arrmodule == $moduleName && $arrmodule_id == "$adminId") {
        return $arrfile_path; // Return the file path for successful upload
    } else {
        return false; // Return false for unsuccessful upload
    }
}
?>
