<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    // Assuming you have all the necessary fields in your frontend form
    $id = isset($data['id']) ? intval($data['id']) : 0;
    $f_name = isset($data['f_name']) ? mysqli_real_escape_string($conn, $data['f_name']) : '';
    $l_name = isset($data['l_name']) ? mysqli_real_escape_string($conn, $data['l_name']) : '';
    $email = isset($data['email']) ? mysqli_real_escape_string($conn, $data['email']) : '';
    $mobile = isset($data['mobile']) ? mysqli_real_escape_string($conn, $data['mobile']) : '';

    // Check if the ID is valid
    if ($id <= 0) {
        throw new Exception('Invalid client ID');
    }

    // Construct the update query based on the collected data
    $updateClientQuery = "UPDATE users SET ";
    $updateClientQuery .= "`f_name` = '$f_name', ";
    $updateClientQuery .= "`l_name` = '$l_name', ";
    $updateClientQuery .= "`username` = '$email', ";
    $updateClientQuery .= "`contact` = '$mobile' ";
    $updateClientQuery .= "WHERE `user_id` = $id";

    // Execute the update query
    $updateClientResult = mysqli_query($conn, $updateClientQuery);

    if ($updateClientResult) {
        $response = array('success' => true, 'message' => 'User data updated successfully', 'updated_data' => $data);

            $by = $id;
            $date = date('Y-m-d H:i:s');
            $module = 'Update Admin Profile';
            $message = "Updated user $id's profile";
    
            insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        throw new Exception('Failed to update user data');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>
