<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("notification/client_notification.php");
include("sendemail/sendMail.php");
include("allmails/allMail.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $senderId = isset($data['senderId']) ? mysqli_real_escape_string($conn, $data['senderId']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;
    $clientId = isset($data['clientId']) ? mysqli_real_escape_string($conn, $data['clientId']) : null;
    $type = isset($data['type']) ? mysqli_real_escape_string($conn, $data['type']) : null;


    // Update trans_per_msg and promocost in clients table
    $updateClientQuery = "UPDATE sender_details SET `sender_id` = '$senderId', `type` = '$type' WHERE `s_id` = '$id'";
    $updateClientResult = mysqli_query($conn, $updateClientQuery);

    if ($updateClientResult) {

        // Select the client 
        $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$clientId'";
        $selectResult = mysqli_query($conn, $selectQuery);

        $row_count = mysqli_num_rows($selectResult);
        if ($row_count < 1) {
            throw new Exception('Client not found');
        }

        $client_data = mysqli_fetch_assoc($selectResult);

        $c_mail = $client_data["email"];
        $client_name = $client_data["f_name"] . " " . $client_data["l_name"];
        $email_sub = $client_data["email_subscribe"];

        $query_system = "SELECT * FROM system_setting";

        $result_system = mysqli_query($conn, $query_system);

        if (mysqli_num_rows($result_system) > 0) {
            $row_system = mysqli_fetch_assoc($result_system);
            //pass row-system to email

            $mailCont = updateSenderid($row_system, $client_name, $c_mail, $senderId, $type);

            $postFileds = [
                'to' => $c_mail, // Recipient's email address
                'sub' => "Sender ID Details Updated - $senderId", // Email subject
                'msg' => $mailCont, // HTML content of the email
                'from' => 'hello@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
            ];

            $sms_details = sendMail($postFileds);

            $sms_details_array = json_decode($sms_details, true);


            $response = array('success' => true, 'message' => 'sender Id updated successfully');

            // admin login
            $by = $adminId;
            $date = date('Y-m-d H:i:s');
            $module = 'update sender Id';
            $message = "Administrator $adminId has successfully updated the senderId name for sender $senderId($id).";

            insertAdminLog($conn, $by, $date, $module, $message);

            // notification
            $title = 'Update Sender Id name';
            $date = date('Y-m-d H:i:s');
            $subtitle = "Updated the sender id name to $senderId .";
            $avatar = 'SI';
            $client_id = $clientId;

            insertNotification($conn, $title, $date, $subtitle, $avatar, $client_id);
        } else {
            throw new Exception("system data not found");
        }
    } else {
        $response = array('success' => false, 'message' => 'Failed to update promo and trans cost');
    }

    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
