<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    // Assuming you have all the necessary fields in your frontend form
    $adminId = isset($data['adminId']) ? intval($data['adminId']) : 0;
    $role = isset($data['role']) ? mysqli_real_escape_string($conn, $data['role']) : '';
    $selectedIds = isset($data['selectedIds']) ? json_encode($data['selectedIds']) : '[]'; // Convert array to JSON string
    $roleId = isset($data['roleId']) ? mysqli_real_escape_string($conn, $data['roleId']) : '';

    // Check if role already exists
    $emailCheckQuery = "SELECT * FROM user_role WHERE `role` = '$role'";
    $emailCheckResult = mysqli_query($conn, $emailCheckQuery);

    if (mysqli_num_rows($emailCheckResult) > 0) {
        $row = mysqli_fetch_assoc($emailCheckResult);
        $role_id = $row["id"];
        if ($role_id !== $roleId) {
            throw new Exception('Role is already available');

        }
    }

    $query = "UPDATE user_role  SET `role` = '$role' , `privilege` = '$selectedIds' WHERE `id` = '$roleId'";

    // Execute the update query
    $result = mysqli_query($conn, $query);

    if ($result) {
        $response = array('success' => true, 'message' => 'Updated a role successfully', 'updated_data' => $data);

        $by = $adminId;
        $date = date('Y-m-d H:i:s');
        $module = 'Update a Role';
        $message = "successfully updated the profile for Role $roleId.";

        insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        throw new Exception('Failed to create a user');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>