<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $title = isset($data['title']) ? mysqli_real_escape_string($conn, $data['title']) : null;
    $message = isset($data['message']) ? mysqli_real_escape_string($conn, $data['message']) : null;
    $status = isset($data['status']) ? mysqli_real_escape_string($conn, $data['status']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;


    $updateQuery = "UPDATE system_setting SET 
    `announce_title` = '$title',
    `announce_message` = '$message',
    `cli_announce_status` = '$status'
    ";

    // echo $updateQuery;

    $updateResult = mysqli_query($conn, $updateQuery);

    if ($updateResult) {
        $response = array('success' => true, 'message' => 'email service updated successfully');
        $by = $adminId;
        $date = date('Y-m-d H:i:s');
        $module = 'update announce';
        $message = "Administrator $adminId has successfully updated the announce section.";

        insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        $response = array('success' => false, 'message' => 'Failed to update email service');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>