<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/x-www-form-urlencoded; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("adminlogs/admin_logs.php");
include ("notification/client_notification.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';
include("sendemail/sendMail.php");
include("allmails/allMail.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];


    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $invoiceNo = isset($data['invoiceNo']) ? mysqli_real_escape_string($conn, $data['invoiceNo']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;
    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;


    $date = date('Y-m-d H:i:s');

    $invoice_query = "SELECT * FROM invoice_header WHERE inovideHID = '$invoiceNo'";
    $invoice_result = mysqli_query($conn, $invoice_query);

    if (mysqli_num_rows($invoice_result) > 0) {
        $invoice_row = mysqli_fetch_assoc($invoice_result);

        $sender_id = $invoice_row['sender_id'];

        $updatesenderId_query = "UPDATE sender_details SET pay_status = 'paid' WHERE s_id = '$sender_id'";
        $updatesenderId_result = mysqli_query($conn, $updatesenderId_query);

        $updateQuery = "UPDATE clients SET productive_cli = 1 WHERE `c_id` = '$id'";
        $updateResult = mysqli_query($conn, $updateQuery);

        $updateinvoice_query = "UPDATE invoice_details set `status` = 'paid', `date` = '$date' WHERE `invoice_HID` = '$invoiceNo'";

        $updateinvoice_result = mysqli_query($conn, $updateinvoice_query);

        if ($updateinvoice_result && $updatesenderId_result) {

            $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$id'";
            $selectResult = mysqli_query($conn, $selectQuery);
    
            $row_count = mysqli_num_rows($selectResult);
            if ($row_count < 1) {
                throw new Exception('Client not found');
            }
    
            $client_data = mysqli_fetch_assoc($selectResult);
    
            $c_mail = $client_data["email"];
            $client_name = $client_data["f_name"] . " " . $client_data["l_name"];
            $company_name = $client_data["company_name"];
            $c_mobile = $client_data["mobile"];
    
            // get invoice details
            $query_invoice = "SELECT * FROM invoice_details WHERE invoice_HID = '$invoiceNo'";
    
            $result_invoice = mysqli_query($conn, $query_invoice);
    
            if (mysqli_num_rows($result_invoice) > 0) {
    
                $row_invoice = mysqli_fetch_assoc($result_invoice);
    
                $total = $row_invoice['total'];
                $date = $row_invoice['date'];
                $description = $row_invoice['description'];
    
    
                $query_system = "SELECT * FROM system_setting";
    
                $result_system = mysqli_query($conn, $query_system);
    
                if (mysqli_num_rows($result_system) > 0) {
                    $row_system = mysqli_fetch_assoc($result_system);
                    //pass row-system to email
    
                    $mailCont = paidInvoice($invoiceNo, $date, $total, $row_system, $client_name, $c_mail, $company_name, $c_mobile, $description);
    
                    $postFileds = [
                        'to' => $c_mail, // Recipient's email address
                        'sub' => "Payment Confirmation - Invoice $invoiceNo", // Email subject
                        'msg' => $mailCont, // HTML content of the email
                        'from' => 'billing@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
                    ];
    
                    $sms_details = sendMail($postFileds);
    
                    $sms_details_array = json_decode($sms_details, true);
    
                    $status_code = $sms_details_array['response']['ErrorCode'];
                    $msg_id = $sms_details_array['response']['MessageID'];
    
                    $response = array('success' => true, 'message' => 'Balance updated successfully');

                    $by = $userId;
                    $date = date('Y-m-d H:i:s');
                    $module = 'Update Invoice Status';
                    $message = "Administrator $userId has successfully Changed status to paid for Invoice $invoiceNo.";
        
                    insertAdminLog($conn, $by, $date, $module, $message);
                } else {
                    throw new Exception("system data not found");
                }
            } else {
                throw new Exception("invoices not found");
            }

          

        } else {
            $response = array('success' => false, 'message' => 'Failed to update balance');
        }

    }

    echo json_encode($response);


} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>