<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("notification/client_notification.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';
include("sendemail/sendMail.php");
include("allmails/allMail.php");


try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? intval($data['id']) : 0;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;

    if ($id <= 0) {
        throw new Exception('Invalid client ID');
    }

    $updateClientQuery = "UPDATE clients SET ";

    if (isset($data['f_name'])) {
        $f_name = mysqli_real_escape_string($conn, $data['f_name']);
        $updateClientQuery .= "`f_name` = '$f_name', ";
    }

    if (isset($data['l_name'])) {
        $l_name = mysqli_real_escape_string($conn, $data['l_name']);
        $updateClientQuery .= "`l_name` = '$l_name', ";
    }

    if (isset($data['email'])) {
        $email = mysqli_real_escape_string($conn, $data['email']);
        $updateClientQuery .= "`email` = '$email', ";
    }

    if (isset($data['mobile'])) {
        $mobile = mysqli_real_escape_string($conn, $data['mobile']);
        $updateClientQuery .= "`mobile` = '$mobile', ";
    }

    if (isset($data['companyName'])) {
        $companyName = mysqli_real_escape_string($conn, $data['companyName']);
        $updateClientQuery .= "`company_name` = '$companyName', ";
    }

    if (isset($data['password'])) {
        $password = mysqli_real_escape_string($conn, $data['password']);
        if ($password !== null && $password !== '') {
            $hashedNewPassword = password_hash($password, PASSWORD_DEFAULT);
            $updateClientQuery .= "`password` = '$hashedNewPassword', ";
        }
    }

    if (isset($data['api_key'])) {
        $api_key = mysqli_real_escape_string($conn, $data['api_key']);
        $updateClientQuery .= "`api_key` = '$api_key', ";
    }

    // Remove the trailing comma and space
    $updateClientQuery = rtrim($updateClientQuery, ', ');

    $updateClientQuery .= " WHERE `c_id` = $id";

    // echo $updateClientQuery;

    $updateClientResult = mysqli_query($conn, $updateClientQuery);

    if ($updateClientResult) {

        $c_mail = $email;
        $client_name = $f_name . " " . $l_name;

        $query_system = "SELECT * FROM system_setting";

        $result_system = mysqli_query($conn, $query_system);

        if (mysqli_num_rows($result_system) > 0) {
            $row_system = mysqli_fetch_assoc($result_system);
            //pass row-system to email

            $mailCont = updateUser($row_system, $client_name, $c_mail);

            $postFileds = [
                'to' => $c_mail, // Recipient's email address
                'sub' => "Profile Details Updated Successfully", // Email subject
                'msg' => $mailCont, // HTML content of the email
                'from' => 'hello@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
            ];

            $sms_details = sendMail($postFileds);

            $sms_details_array = json_decode($sms_details, true);

            $response = array('success' => true, 'message' => 'Client data updated successfully', 'updated_data' => $data);

            // admin logs
            $by = $userId;
            $date = date('Y-m-d H:i:s');
            $module = 'Update a client';
            $message = "Administrator $userId has successfully updated the profile for Client $id.";

            insertAdminLog($conn, $by, $date, $module, $message);

            // notification
            $title = 'Update Profile';
            $date = date('Y-m-d H:i:s');
            $subtitle = "Successfully updated the profile.";
            $avatar = 'PU';
            $client_id = $id;

            insertNotification($conn, $title, $date, $subtitle, $avatar, $client_id);
        } else {
            throw new Exception("system data not found");
        }
    } else {
        throw new Exception('Failed to update client data');
    }


    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
