<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    $json_data = file_get_contents('php://input');

    // Sanitize and decode the JSON data
    $data = json_decode($json_data, true);

    // Initialize variables
    $three_topup_totalCount = 0;
    $seven_topup_totalCount = 0;
    $fourteen_topup_totalCount = 0;
    $thirty_topup_totalCount = 0;
    $sixty_topup_totalCount = 0;
    $ninty_topup_totalCount = 0;


    // Function to execute count query
    function executeCountQuery($conn, $daysAgo, $yesterday)
    {
        $query = "SELECT SUM(cost) as total_amount
        FROM account_history
        WHERE Date(`datetime`) BETWEEN '$daysAgo' AND '$yesterday' AND `type` = 'topup'";

        $result = mysqli_query($conn, $query);
        return $result ? floatval(mysqli_fetch_assoc($result)['total_amount']) : 0;
    }

    // Calculate dates
    $yesterday = date('Y-m-d', strtotime('-1 day'));
    $threeDaysAgo = date('Y-m-d', strtotime('-3 days'));
    $sevenDaysAgo = date('Y-m-d', strtotime('-7 days'));
    $fourteenDaysAgo = date('Y-m-d', strtotime('-14 days'));
    $thirtyDaysAgo = date('Y-m-d', strtotime('-30 days'));
    $sixtyDaysAgo = date('Y-m-d', strtotime('-60 days'));
    $nintyDaysAgo = date('Y-m-d', strtotime('-90 days'));

    // Execute count queries
    $three_topup_totalCount = executeCountQuery($conn, $threeDaysAgo, $yesterday);
    $seven_topup_totalCount = executeCountQuery($conn, $sevenDaysAgo, $yesterday);
    $fourteen_topup_totalCount = executeCountQuery($conn, $fourteenDaysAgo, $yesterday);
    $thirty_topup_totalCount = executeCountQuery($conn, $thirtyDaysAgo, $yesterday);
    $sixty_topup_totalCount = executeCountQuery($conn, $sixtyDaysAgo, $yesterday);
    $ninty_topup_totalCount = executeCountQuery($conn, $nintyDaysAgo, $yesterday);


    // Response
    echo json_encode(array('success' => true, 'threedaystopup' => $three_topup_totalCount, 'sevendaystopup' => $seven_topup_totalCount, 'fourteendaystopup' => $fourteen_topup_totalCount, 'thirtydaystopup' => $thirty_topup_totalCount, 'sixtydaystopup' => $sixty_topup_totalCount, 'nintydaystopup' => $ninty_topup_totalCount));
} catch (\Throwable $th) {
    echo json_encode(array('success' => false, 'message' => $th->getMessage()));
}
?>