<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';


try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $duration = isset($data['duration']) ? mysqli_real_escape_string($conn, $data['duration']) : 'week';

    $client_data = array();

    $yesterday = date('Y-m-d', strtotime('-1 day'));
    $sevenDaysAgo = date('Y-m-d', strtotime('-7 days'));
    $thirtyDaysAgo = date('Y-m-d', strtotime('-30 days'));
    $oneYearAgo = date('Y-m-d', strtotime('-365 days'));

    $query = "SELECT clients.c_id,clients.company_name,clients.f_name,clients.current_balance,SUM(logs.page_count) AS total_page_count FROM clients 
    INNER JOIN logs ON clients.c_id = logs.client_id 
    WHERE 1=1 
      AND clients.status = 1 
      AND clients.verification_status = 1 AND logs.g_deliveryStatus = 2";

    if ($duration == 'week') {
        $query .= " AND Date(logs.create_date) BETWEEN '$sevenDaysAgo' AND '$yesterday'";
    } else if ($duration == 'month') {
        $query .= " AND Date(logs.create_date) BETWEEN '$thirtyDaysAgo' AND '$yesterday'";
    } else if ($duration == 'year') {
        $query .= " AND Date(logs.create_date) BETWEEN '$oneYearAgo' AND '$yesterday'";
    } 
   
    $query .= " GROUP BY clients.c_id ORDER BY total_page_count DESC LIMIT 10";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {

            $client_id = $row['c_id'];

            $topup_Query = "SELECT SUM(topup) as topup FROM topup_history WHERE user_id = $client_id";

            if ($duration == 'week') {
                $topup_Query .= " AND Date(`datetime`) BETWEEN '$sevenDaysAgo' AND '$yesterday'";
            } else if ($duration == 'month') {
                $topup_Query .= " AND Date(`datetime`) BETWEEN '$thirtyDaysAgo' AND '$yesterday'";
            } else if ($duration == 'year') {
                $topup_Query .= " AND Date(`datetime`) BETWEEN '$oneYearAgo' AND '$yesterday'";
            }

            $topup_result = mysqli_query($conn, $topup_Query);

            if ($topup_result) {
                $topup_row = mysqli_fetch_assoc($topup_result)['topup'];
                $row['topup'] = $topup_row;
            }

            $invoice_query = "SELECT COUNT(*) as total_invoice FROM invoice_details WHERE client_id = '$client_id' AND `status` = 'paid'";

            if ($duration == 'week') {
                $invoice_query .= " AND Date(`date`) BETWEEN '$sevenDaysAgo' AND '$yesterday'";
            } else if ($duration == 'month') {
                $invoice_query .= " AND Date(`date`) BETWEEN '$thirtyDaysAgo' AND '$yesterday'";
            } else if ($duration == 'year') {
                $invoice_query .= " AND Date(`date`) BETWEEN '$oneYearAgo' AND '$yesterday'";
            }

            $invoice_result = mysqli_query($conn, $invoice_query);

            if ($invoice_result) {
                $invoice_row = mysqli_fetch_assoc($invoice_result)['total_invoice'];
                $row['total_invoice'] = $invoice_row;
            }

            $client_data[] = $row;

        }

    }

    if (!empty($client_data)) {
        $response = array('success' => true, 'client' => $client_data, 'message' => 'All the client details');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>