<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("notification/client_notification.php");
include("sendemail/sendMail.php");
include("allmails/allMail.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $message = isset($_POST['message']) ? mysqli_real_escape_string($conn, $_POST['message']) : '';
    $id = isset($_POST['id']) ? mysqli_real_escape_string($conn, $_POST['id']) : null;
    $adminId = isset($_POST['adminId']) ? mysqli_real_escape_string($conn, $_POST['adminId']) : null;
    $cid = isset($_POST['cid']) ? mysqli_real_escape_string($conn, $_POST['cid']) : null;

    $date = date('Y-m-d H:i:s');

    $comment = "Replied By admin";
    $comment_admin = "Replied By admin _$adminId";


    // File handling
    if (isset($_FILES['file'])) {

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "http://file.ozonedesk.info/upload.php");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt(
            $ch,
            CURLOPT_POSTFIELDS,
            array(
                'file' => new CURLFile($_FILES['file']['tmp_name'], $_FILES['file']['type'], $_FILES['file']['name']),
                'client_id' => 1001,
                'api_key' => 'os-1121',
                'module' => 'upload file',
                'module_id' => "$id"
            )
        );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $arr = json_decode($result, true);

        $arrstatus = $arr["status"];
        $arrfile_path = $arr["file_path"];
        $arrmodule = $arr["module"];
        $arrmodule_id = $arr["module_id"];

        // Handle the response as needed
        if ($arrstatus == "200" && $arrmodule == "upload file" && $arrmodule_id == "$id") {
            // Successful upload

            $query = "INSERT INTO ticket_details (`tick_id`, `send`, `send_date`, `send_message`, `file`, `to`, `client_id`, `comment`, `comment_admin`) VALUES ('$id', '0', '$date', '$message', '$arrfile_path', '$cid' ,'$cid' , 'Replied By Admin' ,'$adminId')";

            $result = mysqli_query($conn, $query);

            $updateQuery = "UPDATE ticket_header SET `rep_status` = 'admin', `status` = 'close', `comment` ='close ticket by admin' WHERE `id` = '$id'";
            $updateResult = mysqli_query($conn, $updateQuery);

            if ($result && $updateQuery) {

                // Select the client 
                $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$cid'";
                $selectResult = mysqli_query($conn, $selectQuery);

                $row_count = mysqli_num_rows($selectResult);
                if ($row_count < 1) {
                    throw new Exception('Client not found');
                }

                $client_data = mysqli_fetch_assoc($selectResult);

                $c_mail = $client_data["email"];
                $client_name = $client_data["f_name"] . " " . $client_data["l_name"];

                $query_system = "SELECT * FROM system_setting";

                $result_system = mysqli_query($conn, $query_system);

                if (mysqli_num_rows($result_system) > 0) {
                    $row_system = mysqli_fetch_assoc($result_system);
                    //pass row-system to email

                    $mailCont = ticketClose($row_system, $client_name, $c_mail, $id);

                    $postFileds = [
                        'to' => $c_mail, // Recipient's email address
                        'sub' => 'Support Ticket Closed', // Email subject
                        'msg' => $mailCont, // HTML content of the email
                        'from' => 'hello@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
                    ];

                    $sms_details = sendMail($postFileds);

                    $sms_details_array = json_decode($sms_details, true);

                    $response = array('success' => true, 'message' => 'Message and File uploaded successfully');

                    // admin logs
                    $by = $adminId;
                    $date = date('Y-m-d H:i:s');
                    $module = 'Close Ticket';
                    $message = "Administrator $adminId has changed the status to close for ticket $id.";

                    insertAdminLog($conn, $by, $date, $module, $message);
                } else {
                    throw new Exception("system data not found");
                }
            }
        } else {
            // Unsuccessful upload
            $response = array('success' => false, 'message' => 'File upload failed');
        }
    } else {

        $query = "INSERT INTO ticket_details (`tick_id`, `send`, `send_date`, `send_message`, `to`, `client_id`, `comment`, `comment_admin`) VALUES ('$id', '0', '$date', '$message', '$cid' ,'$cid' , 'Replied By Admin', '$adminId')";

        $result = mysqli_query($conn, $query);

        $updateQuery = "UPDATE ticket_header SET `rep_status` = 'admin', `status` = 'close', `comment` ='close ticket by admin' WHERE `id` = '$id'";
        $updateResult = mysqli_query($conn, $updateQuery);

        if ($result && $updateQuery) {
           // Select the client 
           $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$cid'";
           $selectResult = mysqli_query($conn, $selectQuery);

           $row_count = mysqli_num_rows($selectResult);
           if ($row_count < 1) {
               throw new Exception('Client not found');
           }

           $client_data = mysqli_fetch_assoc($selectResult);

           $c_mail = $client_data["email"];
           $client_name = $client_data["f_name"] . " " . $client_data["l_name"];

           $query_system = "SELECT * FROM system_setting";

           $result_system = mysqli_query($conn, $query_system);

           if (mysqli_num_rows($result_system) > 0) {
               $row_system = mysqli_fetch_assoc($result_system);
               //pass row-system to email

               $mailCont = ticketClose($row_system, $client_name, $c_mail, $id);

               $postFileds = [
                   'to' => $c_mail, // Recipient's email address
                   'sub' => 'Support Ticket Closed', // Email subject
                   'msg' => $mailCont, // HTML content of the email
                   'from' => 'hello@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
               ];

               $sms_details = sendMail($postFileds);

               $sms_details_array = json_decode($sms_details, true);

               $response = array('success' => true, 'message' => 'Message and File uploaded successfully');

               // admin logs
               $by = $adminId;
               $date = date('Y-m-d H:i:s');
               $module = 'Close Ticket';
               $message = "Administrator $adminId has changed the status to close for ticket $id.";

               insertAdminLog($conn, $by, $date, $module, $message);
           } else {
               throw new Exception("system data not found");
           }
        }
    }
    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
