<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("sendemail/sendMail.php");
include("allmails/allMail.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;

    $query = "SELECT * FROM users WHERE `user_id` = '$adminId'";
    $result = mysqli_query($conn, $query);

    if ($result) {
        $row = mysqli_fetch_assoc($result);
        $role_id = $row['role_id'];

        $rolequery = "SELECT * FROM user_role WHERE `id` = '$role_id'";
        $roleresult = mysqli_query($conn, $rolequery);

        if ($roleresult) {
            $rolerow = mysqli_fetch_assoc($roleresult);
            $role = $rolerow['role'];

            // Update the status to "cancel"
            $updateStatusQuery = "UPDATE ticket_header SET `status` = 'close', `comment` ='close ticket by $role($adminId)'  WHERE `id` = '$id'";
            $updateStatusResult = mysqli_query($conn, $updateStatusQuery);

            if ($updateStatusResult) {

                $ticketQuery = "SELECT * FROM ticket_header WHERE `id` = '$id'";
                $ticketResult = mysqli_query($conn, $ticketQuery);

                $ticket_count = mysqli_num_rows($ticketResult);

                if ($ticket_count < 1) {
                    throw new Exception('Client not found');
                }
                
                $ticket_data = mysqli_fetch_assoc($ticketResult);
                $c_id = $ticket_data['clent_id'];

                // Select the client 
                $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$c_id'";
                $selectResult = mysqli_query($conn, $selectQuery);

                $row_count = mysqli_num_rows($selectResult);
                if ($row_count < 1) {
                    throw new Exception('Client not found');
                }

                $client_data = mysqli_fetch_assoc($selectResult);

                $c_mail = $client_data["email"];
                $client_name = $client_data["f_name"] . " " . $client_data["l_name"];
                $email_sub = $client_data["email_subscribe"];

                $query_system = "SELECT * FROM system_setting";

                $result_system = mysqli_query($conn, $query_system);

                if (mysqli_num_rows($result_system) > 0) {
                    $row_system = mysqli_fetch_assoc($result_system);
                    //pass row-system to email

                    if($email_sub == 1) {

                        $mailCont = ticketClose($row_system, $client_name, $c_mail, $id);
    
                        $postFileds = [
                            'to' => $c_mail, // Recipient's email address
                            'sub' => "Support Ticket #$id Closed", // Email subject
                            'msg' => $mailCont, // HTML content of the email
                            'from' => 'hello@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
                        ];
    
                        $sms_details = sendMail($postFileds);
    
                        $sms_details_array = json_decode($sms_details, true);
                    }

                    $response = array('success' => true, 'message' => 'Status updated to cancel successfully');

                    // admin logs
                    $by = $adminId;
                    $date = date('Y-m-d H:i:s');
                    $module = 'Close Ticket';
                    $message = "Administrator $adminId has changed the status to cancel for ticket $id.";

                    insertAdminLog($conn, $by, $date, $module, $message);
                } else {
                    throw new Exception("system data not found");
                }
            } else {
                $response = array('success' => false, 'message' => 'Failed to update status to active');
            }
        }
    }

    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
