<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $searchValue = isset($data['searchValue']) ? mysqli_real_escape_string($conn, $data['searchValue']) : null;
    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;
    $status = isset($data['status']) ? mysqli_real_escape_string($conn, $data['status']) : null;
    $page = isset($data['page']) ? intval($data['page']) : 1;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $technical_data = array();
    $row_totalCount = 0;

    $offset = ($page - 1) * $pageSize;

    $count_query = "SELECT COUNT(*) as total FROM ticket_header WHERE `department` = 'technical' AND `status` != 'close' AND (`assign_id` = '$adminId' OR `assign_id` IS NULL)";

    if ($searchValue !== null && $searchValue !== '') {
        $count_query .= " AND (id = '$searchValue' OR category LIKE '%$searchValue%' OR `priority` LIKE '%$searchValue%')";
    }

    if ($c_id !== null && $c_id !== '') {
        $count_query .= " AND clent_id = '$c_id'";
    }

    if ($status !== null && $status !== '') {
        $count_query .= " AND status = '$status'";
    }

    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }
    // .........................................................................................................

    // Fetch clients without considering 

    $query = "SELECT * FROM ticket_header WHERE `department` = 'technical' AND `status` != 'close' AND (`assign_id` = '$adminId' OR `assign_id` IS NULL)";


    if ($searchValue !== null && $searchValue !== '') {
        $query .= " AND (id = '$searchValue' OR category LIKE '%$searchValue%' OR `priority` LIKE '%$searchValue%')";
    }

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND clent_id = '$c_id'";
    }

    if ($status !== null && $status !== '') {
        $query .= " AND status = '$status'";
    }


    $query .= "  ORDER BY `id` DESC";

    $query .= " LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['clent_id'];
            $ticket_id = $row['id'];

            //  client details
            $client_query = "SELECT f_name,l_name,email,mobile,company_name FROM `clients` WHERE `c_id` = $client_id";

            $client_result = mysqli_query($conn, $client_query);

            $client_row_count = mysqli_num_rows($client_result);

            if ($client_row_count == 1) {

                $client_row = mysqli_fetch_assoc($client_result);

                $client_data = $client_row;

                $row['client_details'] = $client_data;

            }

            // last message date

            $message_query = "SELECT `send_date` FROM `ticket_details` WHERE `tick_id` = '$ticket_id' ORDER BY id DESC LIMIT 1";

            $message_result = mysqli_query($conn, $message_query);

            if ($message_result) {
                $message_row = mysqli_fetch_assoc($message_result);

                $row['admin_date'] = $message_row;
            }

            $technical_data[] = $row;
        }

    }


    if (!empty($technical_data)) {
        $response = array('success' => true, 'ticket' => $technical_data, 'total' => $row_totalCount, 'message' => 'all technocal ticket');
    } else {
        $response = array('success' => false, 'message' => 'No tickets found');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>