<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

function executeCountQuery($conn, $startDate, $endDate, $department, $status)
{
    $query = "SELECT COUNT(*) as total FROM ticket_header WHERE department='$department' AND `status` = '$status'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND `date` BETWEEN '$startDate' AND '$endDate'";
    }

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

function reOpenCountQuery($conn, $startDate, $endDate, $department, $status)
{
    $query = "SELECT COUNT(*) as total FROM ticket_header WHERE department='$department' AND `status` = '$status' AND (comment = 'reopened ticket by client' OR comment = 'reopened ticket by admin')";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND `date` BETWEEN '$startDate' AND '$endDate'";
    }

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

function adminCountQuery($conn, $startDate, $endDate, $department)
{
    $query = "SELECT COUNT(*) as total FROM ticket_details INNER JOIN ticket_header ON ticket_details.tick_id =  ticket_header.id WHERE ticket_header.department='$department' AND `send` = 0";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND ticket_details.send_date BETWEEN '$startDate' AND '$endDate'";
    }

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

function clientCountQuery($conn, $startDate, $endDate, $department)
{
    $query = "SELECT COUNT(*) as total FROM ticket_details INNER JOIN ticket_header ON ticket_details.tick_id =  ticket_header.id WHERE ticket_header.department='$department' AND `send` != 0";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND ticket_details.send_date BETWEEN '$startDate' AND '$endDate'";
    }

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

        $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $department = isset($data['department']) ? mysqli_real_escape_string($conn, $data['department']) : '';

    $techincal_open_count = 0;
    $techincal_close_count = 0;
    $techincal_hold_count = 0;
    $billing_open_count = 0;
    $billing_close_count = 0;
    $billing_hold_count = 0;
    $sales_open_count = 0;
    $sales_close_count = 0;
    $sales_hold_count = 0;
    $technical_reopen_count = 0;
    $billing_reopen_count = 0;
    $sales_reopen_count = 0;
    $technical_admin_count = 0;
    $billing_admin_count = 0;
    $sales_admin_count = 0;
    $technical_client_count = 0;
    $billing_client_count = 0;
    $sales_client_count = 0;

    if ($department == 'all') {

        $techincal_open_count = executeCountQuery($conn, $startDate, $endDate, 'technical', 'pending');
        $techincal_close_count = executeCountQuery($conn, $startDate, $endDate, 'technical', 'close');
        $techincal_hold_count = executeCountQuery($conn, $startDate, $endDate, 'technical', 'hold');
        $billing_open_count = executeCountQuery($conn, $startDate, $endDate, 'billing', 'pending');
        $billing_close_count = executeCountQuery($conn, $startDate, $endDate, 'billing', 'close');
        $billing_hold_count = executeCountQuery($conn, $startDate, $endDate, 'billing', 'hold');
        $sales_open_count = executeCountQuery($conn, $startDate, $endDate, 'sales', 'pending');
        $sales_close_count = executeCountQuery($conn, $startDate, $endDate, 'sales', 'close');
        $sales_hold_count = executeCountQuery($conn, $startDate, $endDate, 'sales', 'hold');
        $technical_reopen_count = reOpenCountQuery($conn, $startDate, $endDate, 'technical', 'pending');
        $billing_reopen_count = reOpenCountQuery($conn, $startDate, $endDate, 'billing', 'pending');
        $sales_reopen_count = reOpenCountQuery($conn, $startDate, $endDate,'sales', 'pending');
        $technical_admin_count = adminCountQuery($conn, $startDate, $endDate, 'technical');
        $billing_admin_count = adminCountQuery($conn, $startDate, $endDate, 'billing');
        $sales_admin_count = adminCountQuery($conn, $startDate, $endDate,'sales');
        $technical_client_count = clientCountQuery($conn, $startDate, $endDate, 'technical');
        $billing_client_count = clientCountQuery($conn, $startDate, $endDate, 'billing');
        $sales_client_count = clientCountQuery($conn, $startDate, $endDate,'sales');

    } else if ($department == 'technical') {

        $techincal_open_count = executeCountQuery($conn, $startDate, $endDate, 'technical', 'pending');
        $techincal_close_count = executeCountQuery($conn, $startDate, $endDate, 'technical', 'close');
        $techincal_hold_count = executeCountQuery($conn, $startDate, $endDate, 'technical', 'hold');
        $technical_reopen_count = reOpenCountQuery($conn, $startDate, $endDate, 'technical', 'pending');
        $technical_admin_count = adminCountQuery($conn, $startDate, $endDate, 'technical');
        $technical_client_count = clientCountQuery($conn, $startDate, $endDate, 'technical');

    } else if($department == 'billing') {

        $billing_open_count = executeCountQuery($conn, $startDate, $endDate, 'billing', 'pending');
        $billing_close_count = executeCountQuery($conn, $startDate, $endDate, 'billing', 'close');
        $billing_hold_count = executeCountQuery($conn, $startDate, $endDate, 'billing', 'hold');
        $billing_reopen_count = reOpenCountQuery($conn, $startDate, $endDate, 'billing', 'pending');
        $billing_admin_count = adminCountQuery($conn, $startDate, $endDate, 'billing');
        $billing_client_count = clientCountQuery($conn, $startDate, $endDate, 'billing');

    } else if ($department == 'sales') {

        $sales_open_count = executeCountQuery($conn, $startDate, $endDate,'sales', 'pending');
        $sales_close_count = executeCountQuery($conn, $startDate, $endDate,'sales', 'close');
        $sales_hold_count = executeCountQuery($conn, $startDate, $endDate,'sales', 'hold');
        $sales_reopen_count = reOpenCountQuery($conn, $startDate, $endDate,'sales', 'pending');
        $sales_admin_count = adminCountQuery($conn, $startDate, $endDate,'sales');
        $sales_client_count = clientCountQuery($conn, $startDate, $endDate,'sales');

    }  else {

        throw new Exception('Invalid department');
    }

    echo json_encode(array('success' => true, 'technicalopen' => $techincal_open_count, 'technicalclose' => $techincal_close_count, 'technicalhold' => $techincal_hold_count, 'billingopen' => $billing_open_count, 'billingclose' => $billing_close_count, 'billinghold' => $billing_hold_count,'salesopen' => $sales_open_count, 'salesclose' => $sales_close_count, 'saleshold' => $sales_hold_count, 'technicalreopen' => $technical_reopen_count, 'billingreopen' => $billing_reopen_count, 'salesreopen' => $sales_reopen_count, 'technicaladmin' => $technical_admin_count, 'billingadmin' => $billing_admin_count, 'salesadmin' => $sales_admin_count, 'technicalclient' => $technical_client_count, 'billingclient' => $billing_client_count, 'salesclient' => $sales_client_count));

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>