<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $sId = isset($data['sId']) ? mysqli_real_escape_string($conn, $data['sId']) : null;
    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;

    $query = "SELECT * FROM logs WHERE sender_id = '$sId' AND client_id='$id' ORDER BY `clog_id` DESC LIMIT 5";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {
        $smslog_data = array();

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['client_id'];

            
            $serverResponse = json_decode($row["serverResponse"]);


            if (is_object($serverResponse)) {
                $row["serverResponse"] = $serverResponse;
            }


            $client_query = "SELECT f_name,l_name,c_id,mobile,company_name FROM `clients` WHERE `c_id` = $client_id";

            $client_result = mysqli_query($conn, $client_query);

            $client_row_count = mysqli_num_rows($client_result);

            if ($client_row_count = 1) {

                while ($client_row = mysqli_fetch_assoc($client_result)) {
                    $client_data = $client_row;
                }

                $row['client_details'] = $client_data;
                $smslog_data[] = $row;
            }
        }

        $response = array('success' => true, 'smslog' => $smslog_data, 'message' => 'All the sms');
    } else {
        $response = array('success' => false, 'message' => 'No clients found');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>