<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $smslog_data = array();
    $row_totalCount = 0;

    $offset = ($page) * $pageSize;

    $count_query = "
    SELECT COUNT(*) AS total_rows
    FROM (
        SELECT 
            DATE(`create_date`) AS `log_date`,
            `client_id`,
            `sender_id`
        FROM `logs`
        WHERE `type` = 'bulk'";

    // Add date range filter if provided
    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $count_query .= " AND `create_date` BETWEEN '$startDate' AND '$endDate'";
    }

    // Add client ID filter if provided
    if ($c_id !== null && $c_id !== '') {
        $count_query .= " AND `client_id` = '$c_id'";
    }

    // Group by date and client_id
    $count_query .= "
        GROUP BY DATE(`create_date`), `client_id`
    ) AS grouped_data;";

    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total_rows'];
        $row_totalCount = intval($row_totalCount);
    }
    // .........................................................................................................

    $query = "SELECT 
        DATE(`create_date`) AS `log_date`,
        `compaign_id`,
        `client_id`,
        `sender_id`,
        COUNT(*) AS sent_count,
        COUNT(CASE WHEN `g_deliveryStatus` = 1 THEN 1 END) AS pending_count,
        COUNT(CASE WHEN `g_deliveryStatus` = 2 THEN 1 END) AS delivered_count,
        COUNT(CASE WHEN `g_deliveryStatus` = 3 THEN 1 END) AS failed_count
        FROM `logs`
        WHERE `type` = 'bulk'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND `create_date` BETWEEN '$startDate' AND '$endDate'";
    }

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND `client_id` = '$c_id'";
    }

    $query .= "GROUP BY DATE(`create_date`), `client_id` ORDER BY `log_date` DESC, `client_id` LIMIT $pageSize OFFSET $offset";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['client_id'];
            $campaign_id = $row['compaign_id'];

            $campaign_query = "SELECT compaign_status, schedule_date, schedule_time FROM compaign_details WHERE compaign_id =?";
            $campaign_statement = mysqli_prepare($conn, $campaign_query);
            mysqli_stmt_bind_param($campaign_statement, "i", $campaign_id);
            mysqli_stmt_execute($campaign_statement);
            $campaign_result = mysqli_stmt_get_result($campaign_statement);

            if($camaign_row = mysqli_fetch_assoc($campaign_result)){
                $row['campaign_details'] = $camaign_row;
                
            }

            $client_query = "SELECT f_name, l_name, c_id, mobile, company_name FROM clients WHERE c_id = ?";
            $client_statement = mysqli_prepare($conn, $client_query);
            mysqli_stmt_bind_param($client_statement, "i", $client_id);
            mysqli_stmt_execute($client_statement);
            $client_result = mysqli_stmt_get_result($client_statement);

            // Fetch client details
            if ($client_row = mysqli_fetch_assoc($client_result)) {
                $row['client_details'] = $client_row;
               
            }
            $smslog_data[] = $row;
        }
    }


    if (!empty($smslog_data)) {
        $response = array('success' => true, 'smslog' => $smslog_data, 'total' => $row_totalCount, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
