<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';


try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $senderid = isset($data['senderid']) ? mysqli_real_escape_string($conn, $data['senderid']) : null;
    $gateway = isset($data['gateway']) ? mysqli_real_escape_string($conn, $data['gateway']) : null;
    $stype = isset($data['stype']) ? mysqli_real_escape_string($conn, $data['stype']) : null;
    $orderType = isset($data['orderType']) ? mysqli_real_escape_string($conn, $data['orderType']) : 'ASC';
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $smslog_data = array();
    $row_totalCount = 0;

    $offset = ($page) * $pageSize;

    // calculate total row
    $countQuery = "SELECT COUNT(*) as total FROM ( SELECT logs.client_id, logs.sender_id,sender_details.date,sender_details.status,sender_details.defaultGatway FROM logs INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id WHERE 1=1 AND logs.g_deliveryStatus = 2 AND logs.sender_id != 'ozoneDEMO' AND logs.sender_id != 'oZoneSender'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $countQuery .= " AND logs.create_date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($senderid !== null && $senderid !== '') {
        $countQuery .= " AND logs.sender_id = '$senderid'";
    }

    if ($c_id !== null && $c_id !== '') {
        $countQuery .= " AND logs.client_id = '$c_id'";
    }

    if ($stype !== null && $stype !== '') {
        $countQuery .= " AND sender_details.type = '$stype'";
    }

    if ($gateway !== null && $gateway !== '') {
        $countQuery .= " AND sender_details.defaultGatway = '$gateway'";
    }

    $countQuery .= " GROUP BY logs.client_id, logs.sender_id) as subquery";

    $count_result = mysqli_query($conn, $countQuery);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }

    // .........................................................................
    $query = "SELECT sender_details.s_id,sender_details.date,sender_details.status,sender_details.defaultGatway,logs.client_id,logs.sender_id,SUM(logs.page_count) as total_page, SUM(CASE WHEN logs.g_deliveryStatus = 2 THEN logs.page_count ELSE 0 END) as 'delivered_total',SUM(CASE WHEN logs.g_deliveryStatus = 3 THEN logs.page_count ELSE 0 END) as 'failed_total' FROM logs INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id WHERE 1=1 AND logs.g_deliveryStatus = 2 AND logs.sender_id != 'ozoneDEMO' AND logs.sender_id != 'oZoneSender'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND logs.create_date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($senderid !== null && $senderid !== '') {
        $query .= " AND logs.sender_id = '$senderid'";
    }

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND logs.client_id = '$c_id'";
    }


    if ($stype !== null && $stype !== '') {
        $query .= " AND sender_details.type = '$stype'";
    }

    if ($gateway !== null && $gateway !== '') {
        $query .= " AND sender_details.defaultGatway = '$gateway'";
    }

    $query .= " GROUP BY logs.client_id, logs.sender_id";

    $query .= " ORDER BY total_page $orderType";

    $query .= " LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['client_id'];
            $sender_id = $row['sender_id'];
            $gateway = $row['defaultGatway'];

            $client_query = "SELECT f_name, l_name,company_name,c_id FROM clients WHERE c_id = ?";
            $client_statement = mysqli_prepare($conn, $client_query);
            mysqli_stmt_bind_param($client_statement, "i", $client_id);
            mysqli_stmt_execute($client_statement);
            $client_result = mysqli_stmt_get_result($client_statement);

            // Fetch client details
            if ($client_row = mysqli_fetch_assoc($client_result)) {
                $row['client_details'] = $client_row;
            }

            $senderid_query = "SELECT s_id, sender_id FROM sender_details WHERE client_id = ? AND sender_id = ? ";
            $sender_statement = mysqli_prepare($conn, $senderid_query);
            mysqli_stmt_bind_param($sender_statement, "is", $client_id, $sender_id);
            mysqli_stmt_execute($sender_statement);
            $sender_result = mysqli_stmt_get_result($sender_statement);

            // Fetch client details
            if ($sender_row = mysqli_fetch_assoc($sender_result)) {
                $row['sender_details'] = $sender_row;

            }

            $gateway_query = "SELECT id, route_name FROM gateway WHERE id = ?  ";
            $gateway_statement = mysqli_prepare($conn, $gateway_query);
            mysqli_stmt_bind_param($gateway_statement, "i", $gateway);
            mysqli_stmt_execute($gateway_statement);
            $gateway_result = mysqli_stmt_get_result($gateway_statement);

            // Fetch client details
            if ($gateway_row = mysqli_fetch_assoc($gateway_result)) {
                $row['gateway'] = $gateway_row;

            }

            $smslog_data[] = $row;
        }

    }


    if (!empty($smslog_data)) {
        $response = array('success' => true, 'smslog' => $smslog_data, 'total' => $row_totalCount, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>