<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $value = isset($data['value']) ? mysqli_real_escape_string($conn, $data['value']) : null;
  

    $sender_data = array();

    $query = "SELECT * FROM sender_details WHERE `status`='pending' AND adminStatus = 'pending' AND noc_letter IS NOT NULL";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND `date` BETWEEN '$startDate' AND '$endDate'";
    }

    if ($value !== null && $value !== '') {
        $query .= " AND `s_id` = '$value'";
    }

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND `client_id` = '$c_id'";
    }

    $query .= "  ORDER BY `s_id` DESC";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {

            $client_id = $row['client_id'];

            $client_query = "SELECT f_name,l_name,email,mobile FROM `clients` WHERE `c_id` = $client_id";

            $client_result = mysqli_query($conn, $client_query);

            $client_row_count = mysqli_num_rows($client_result);

            if ($client_row_count == 1) {
                $client_row = mysqli_fetch_assoc($client_result);
                $client_data = $client_row;

                $row['client_details'] = $client_data;
                $sender_data[] = $row;
            }
        }

    }


    if (!empty($sender_data)) {
        $response = array('success' => true, 'sender' => $sender_data, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>