<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $value = isset($data['value']) ? $data['value'] : null;
   
    $client_data = array();

    $clients_query = "SELECT * FROM clients WHERE status = 1 AND `verification_status` = 1";

    if ($value !== null && $value !== '') {
        $clients_query .= " AND (c_id = '$value' OR company_name LIKE '%$value%' OR f_name LIKE '%$value%')";
    }

    $clients_result = mysqli_query($conn, $clients_query);

    if (!$clients_result) {
        throw new Exception('Error executing the query');
    }

    while ($client_row = mysqli_fetch_assoc($clients_result)) {
        $client_data[] = $client_row;
    }

    if (!empty($client_data)) {
        $response = array('success' => true, 'client' => $client_data, 'message' => 'invoice found within the date range');
    } else {
        $response = array('success' => false, 'message' => 'No invoice found within the date range');
    }

    echo json_encode($response);

    // Close the database connection
    mysqli_close($conn);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>