<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $searchany = isset($data['searchany']) ? mysqli_real_escape_string($conn, $data['searchany']) : null;


    $query = "SELECT * FROM user_role WHERE 1=1";

    if ($searchany !== null && $searchany !== '') {
        $query .= " AND (id = '$searchany' OR `role` = '$searchany')";
    }

    $query .= " ORDER BY `id` DESC";

    $result = mysqli_query($conn, $query);

    if ($result) {
        $role_data = array();

        while ($row = mysqli_fetch_assoc($result)) {
            $role_role = json_decode($row["privilege"]);
            $row["privilege"] = $role_role;
            $role_data[] = $row;
        }

        $response = array('success' => true, 'user' => $role_data, 'message' => 'successful');

    } else {
        // Authentication failed
        $response = array('success' => false, 'message' => 'invalid user id');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>