<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';


function senderIDCountQuery($conn, $id, $startDate, $endDate)
{
    $query = "SELECT COUNT(*) as total FROM sender_details WHERE defaultGatway='$id' AND sender_id != 'ozoneDEMO' AND sender_id != 'oZoneSender'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND `date` BETWEEN '$startDate' AND '$endDate'";
    }

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

function routeRequestCountQuery($conn, $id, $startDate, $endDate)
{
    $query = "SELECT COUNT(*) as total FROM logs INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id WHERE sender_details.defaultGatway='$id'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND logs.create_date BETWEEN '$startDate' AND '$endDate'";
    }

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

function pageCountQuery($conn, $id, $startDate, $endDate)
{
    $query = "SELECT SUM(page_count) as total FROM logs INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id WHERE sender_details.defaultGatway='$id'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND logs.create_date BETWEEN '$startDate' AND '$endDate'";
    }

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

function sentCountQuery($conn, $id, $startDate, $endDate)
{
    $query = "SELECT COUNT(*) as total FROM logs INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id WHERE sender_details.defaultGatway='$id' AND logs.g_deliveryStatus = 0";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND logs.create_date BETWEEN '$startDate' AND '$endDate'";
    }

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

function deliveredCountQuery($conn, $id, $startDate, $endDate)
{
    $query = "SELECT COUNT(*) as total FROM logs INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id WHERE sender_details.defaultGatway='$id' AND logs.g_deliveryStatus = 2";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND logs.create_date BETWEEN '$startDate' AND '$endDate'";
    }

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

function failedCountQuery($conn, $id, $startDate, $endDate)
{
    $query = "SELECT COUNT(*) as total FROM logs INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id WHERE sender_details.defaultGatway='$id' AND logs.g_deliveryStatus = 3";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND logs.create_date BETWEEN '$startDate' AND '$endDate'";
    }

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    
    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $route = isset($data['route']) ? mysqli_real_escape_string($conn, $data['route']) : '';

    $route_data = array();

    $query = "SELECT id,route_name FROM gateway WHERE 1=1";

    if ($route !== null && $route !== '') {
        $query .= " AND id = '$route'";
    }

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {

            $id = $row['id'];

            $senderid_count = senderIDCountQuery($conn, $id, $startDate, $endDate);
            $row['senderid_count'] = $senderid_count;

            $route_request = routeRequestCountQuery($conn, $id, $startDate, $endDate);
            $row['route_request'] = $route_request;

            $page_count = pageCountQuery($conn, $id, $startDate, $endDate);
            $row['page_count'] = $page_count;
           
            $sent = sentCountQuery($conn, $id, $startDate, $endDate);
            $row['sent'] = $sent;

            $delivered = deliveredCountQuery($conn, $id, $startDate, $endDate);
            $row['delivered'] = $delivered;

            $failed = failedCountQuery($conn, $id, $startDate, $endDate);
            $row['failed'] = $failed;

            $route_data[] = $row;

        }

    }

    if (!empty($route_data)) {
        $response = array('success' => true, 'client' => $route_data, 'message' => 'All the client details');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>