<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $value = isset($data['value']) ? mysqli_real_escape_string($conn, $data['value']) : null;
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $reseller_data = array();
    $row_totalCount = 0;

    $offset = ($page) * $pageSize;

    $count_query = "SELECT COUNT(*) as total FROM reseller WHERE 1=1 ";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $count_query .= " AND request_date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($value !== null && $value !== '') {
        $count_query .= " AND (mobile = '$value' OR email LIKE '%$value%')";
    }

    if ($c_id !== null && $c_id !== '') {
        $count_query .= " AND agent = '$c_id'";
    }

    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }
    // .........................................................................................................

    $query = "SELECT * FROM reseller WHERE 1=1 ";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND request_date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($value !== null && $value !== '') {
        $query .= " AND (mobile = '$value' OR email LIKE '%$value%')";
    }

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND agent = '$c_id'";
    }

    $query .= "  ORDER BY `id` DESC";

    $query .= " LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            // $client_id = $row['agent'];

            // $client_query = "SELECT f_name, l_name, c_id, mobile, company_name FROM clients WHERE c_id = ?";
            // $client_statement = mysqli_prepare($conn, $client_query);
            // mysqli_stmt_bind_param($client_statement, "i", $client_id);
            // mysqli_stmt_execute($client_statement);
            // $client_result = mysqli_stmt_get_result($client_statement);

            // // Fetch client details
            // if ($client_row = mysqli_fetch_assoc($client_result)) {
            //     $row['client_details'] = $client_row;
            //     $reseller_data[] = $row;
            // }
            $reseller_data[] = $row;
        }

    }


    if (!empty($reseller_data)) {
        $response = array('success' => true, 'reseller' => $reseller_data, 'total' => $row_totalCount, 'message' => 'All the reseller data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>