<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $role = isset($data['role']) ? mysqli_real_escape_string($conn, $data['role']) : null;
    $sid = isset($data['sid']) ? mysqli_real_escape_string($conn, $data['sid']) : null;
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $sender_data = array();

    $offset = ($page) * $pageSize;

    $row_totalCount = 0;

    $count_query = "SELECT COUNT(*) as total FROM sender_details WHERE `adminStatus` IN ('noapproved', 'cancel') ";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $count_query .= " AND `date` BETWEEN '$startDate' AND '$endDate'";
    }

    if ($role !== null && $role !== '') {
        $count_query .= " AND `sender_id` = '$role'";
    }

    if ($sid !== null && $sid !== '') {
        $count_query .= " AND `s_id` = '$sid'";
    }

    if ($c_id !== null && $c_id !== '') {
        $count_query .= " AND `client_id` = '$c_id'";
    }

    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }

    // .........................................................................................................


    $query = "SELECT * FROM sender_details WHERE `adminStatus` IN ('noapproved', 'cancel') ";

    $params = [];
    $types = "";

    // Add conditions dynamically
    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND `date` BETWEEN ? AND ?";
        $params[] = $startDate;
        $params[] = $endDate;
        $types .= "ss"; // Two strings for the date range
    }

    if ($role !== null && $role !== '') {
        $query .= " AND `sender_id` = ?";
        $params[] = $role;
        $types .= "s"; // String for role
    }

    if ($sid !== null && $sid !== '') {
        $query .= " AND `s_id` = ?";
        $params[] = $sid;
        $types .= "s"; // String for s_id
    }

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND `client_id` = ?";
        $params[] = $c_id;
        $types .= "s"; // String for client_id
    }

    $query .= " ORDER BY `s_id` DESC";
    $query .= " LIMIT ?, ?";

    // Add limit parameters
    $params[] = $offset;
    $params[] = $pageSize;
    $types .= "ii"; // Two integers for LIMIT

    // Prepare statement
    $sender_statement = mysqli_prepare($conn, $query);

    // Bind parameters dynamically
    if ($params) {
        mysqli_stmt_bind_param($sender_statement, $types, ...$params);
    }

    // Execute and get the result
    mysqli_stmt_execute($sender_statement);
    $result = mysqli_stmt_get_result($sender_statement);


    while ($row = mysqli_fetch_assoc($result)) {

        $client_id = $row['client_id'];

        $client_query = "SELECT f_name,l_name,email,mobile,company_name FROM `clients` WHERE `c_id` = ?";
        $client_statement = mysqli_prepare($conn, $client_query);
        mysqli_stmt_bind_param($client_statement, 'i', $client_id);
        mysqli_stmt_execute($client_statement);
        $client_result = mysqli_stmt_get_result($client_statement);
    
        if ($client_result && $client_row = mysqli_fetch_assoc($client_result)) {
            $row['client_details'] = $client_row;
        } else {
            $row['client_details'] = null;
        }
    
        mysqli_stmt_close($client_statement);

        $sender_data[] = $row;
    }

    // Close statement
    mysqli_stmt_close($sender_statement);


    if (!empty($sender_data)) {
        $response = array('success' => true, 'sender' => $sender_data, 'total' => $row_totalCount, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>