<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("notification/client_notification.php");


try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;
    $cid = isset($data['cid']) ? mysqli_real_escape_string($conn, $data['cid']) : null;


    // Update the status to "cancel"
    $updateStatusQuery = "UPDATE sender_details SET `adminStatus` = 'noapproved' WHERE `s_id` = '$id'";
    $updateStatusResult = mysqli_query($conn, $updateStatusQuery);

    if ($updateStatusResult) {
        $response = array('success' => true, 'message' => 'Status updated to active successfully');

        // admin logs
        $by = $adminId;
        $date = date('Y-m-d H:i:s');
        $module = 'adminStatus SenderId';
        $message = "Administrator $adminId has changed the adminStatus to noapproved for senderid $id.";

        insertAdminLog($conn, $by, $date, $module, $message);

         // notification
         $title = 'Reject Sender ID';
         $date = date('Y-m-d H:i:s');
         $subtitle = "Sender ID ($id) has not been approved";
         $avatar = 'SI';
         $client_id = $cid;
 
         insertNotification($conn, $title, $date, $subtitle, $avatar, $client_id);

    } else {
        $response = array('success' => false, 'message' => 'Failed to update status to active');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>
