<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $route = isset($data['route']) ? mysqli_real_escape_string($conn, $data['route']) : '';
    $type = isset($data['type']) ? mysqli_real_escape_string($conn, $data['type']) : '';

    $route_data = array();

    $query = "SELECT gateway.route_name, sender_details.type, SUM(logs.page_count) as sms_count ,SUM(logs.total_cost) as total_cost,SUM(logs.route_cost) as route_cost FROM sender_details INNER JOIN logs ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id INNER JOIN gateway ON sender_details.defaultGatway = gateway.id WHERE logs.g_deliveryStatus = 2";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND logs.send_date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($route !== null && $route !== '') {
        $query .= " AND sender_details.defaultGatway = '$route'";
    }

    if ($type !== null && $type !== '') {
        $query .= " AND sender_details.type = '$type'";
    }

    $query.= " GROUP BY gateway.route_name, sender_details.type";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $total_cost = floatval($row['total_cost']); // Convert to float
            $route_cost = floatval($row['route_cost']); // Convert to float

            $profit = $total_cost - $route_cost;

            $row['profit'] = $profit;

            $route_data[] = $row;

        }

    }

    if (!empty($route_data)) {
        $response = array('success' => true, 'client' => $route_data, 'message' => 'All the client details');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>