<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    $json_data = file_get_contents('php://input');

    // Sanitize and decode the JSON data
    $data = json_decode($json_data, true);

    // Initialize variables
    $three_client_totalCount = 0;
    $seven_client_totalCount = 0;
    $fourteen_client_totalCount = 0;
    $thirty_client_totalCount = 0;
    $sixty_client_totalCount = 0;
    $ninty_client_totalCount = 0;

    // Function to execute count query
    function executeCountQuery($conn, $daysAgo, $yesterday)
    {
        $query = "SELECT COUNT(*) as 'total'
            FROM (
                SELECT invoice_details.client_id, COUNT(invoice_details.status) as 'status'
                FROM `invoice_details`
                INNER JOIN `clients`
                ON invoice_details.client_id = clients.c_id
                WHERE invoice_details.status = 'paid'
                    AND Date(clients.register_date) BETWEEN '$daysAgo' AND '$yesterday'
                GROUP BY client_id
            ) as subquery";

        $result = mysqli_query($conn, $query);
        return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
    }

    // Calculate dates
    $yesterday = date('Y-m-d', strtotime('-1 day'));
    $threeDaysAgo = date('Y-m-d', strtotime('-3 days'));
    $sevenDaysAgo = date('Y-m-d', strtotime('-7 days'));
    $fourteenDaysAgo = date('Y-m-d', strtotime('-14 days'));
    $thirtyDaysAgo = date('Y-m-d', strtotime('-30 days'));
    $sixtyDaysAgo = date('Y-m-d', strtotime('-60 days'));
    $nintyDaysAgo = date('Y-m-d', strtotime('-90 days'));

    // Execute count queries
    $three_client_totalCount = executeCountQuery($conn, $threeDaysAgo, $yesterday);
    $seven_client_totalCount = executeCountQuery($conn, $sevenDaysAgo, $yesterday);
    $fourteen_client_totalCount = executeCountQuery($conn, $fourteenDaysAgo, $yesterday);
    $thirty_client_totalCount = executeCountQuery($conn, $thirtyDaysAgo, $yesterday);
    $sixty_client_totalCount = executeCountQuery($conn, $sixtyDaysAgo, $yesterday);
    $ninty_client_totalCount = executeCountQuery($conn, $nintyDaysAgo, $yesterday);

    // Response
    echo json_encode(array('success' => true, 'threedaysclient' => $three_client_totalCount, 'sevendaysclient' => $seven_client_totalCount, 'fourteendaysclient' => $fourteen_client_totalCount, 'thirtydaysclient' => $thirty_client_totalCount, 'sixtydaysclient' => $sixty_client_totalCount, 'nintydaysclient' => $ninty_client_totalCount));
} catch (\Throwable $th) {
    echo json_encode(array('success' => false, 'message' => $th->getMessage()));
}
?>
