<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;

    $query = "SELECT * FROM ticket_header WHERE id = '$id'";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count == 1) {

        $row = mysqli_fetch_assoc($result);

        $client_id = $row['clent_id'];

        //  client details
        $client_query = "SELECT f_name,l_name,email,mobile,company_name FROM `clients` WHERE `c_id` = $client_id";

        $client_result = mysqli_query($conn, $client_query);

        $client_row_count = mysqli_num_rows($client_result);

        if ($client_row_count == 1) {

            $client_row = mysqli_fetch_assoc($client_result);

            $client_data = $client_row;

            $row['client_details'] = $client_data;

        }

    }


    if (!empty($row)) {
        $response = array('success' => true, 'ticket' => $row, 'message' => 'all technocal ticket');
    } else {
        $response = array('success' => false, 'message' => 'No tickets found');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>