<?php
require 'vendor/autoload.php';
use \Firebase\JWT\JWT;
use \Firebase\JWT\Key;


function validateJWT($headers, $secretKey) {
   
    if (!isset($headers['Authorization'])) {
        http_response_code(401);
        throw new Exception('Authorization header not found');
    }
    
    $authHeader = $headers['Authorization'];
    
    $arr = explode(" ", $authHeader);

    if (count($arr) != 2 || $arr[0] != 'Bearer') {
        http_response_code(400);
        throw new Exception('Invalid authorization format');
    }

    $jwt = $arr[1];
    // echo $jwt;

    try {
        $decoded = JWT::decode($jwt, new Key($secretKey, 'HS256'));
        return (array) $decoded;
    } catch (Exception $e) {
        http_response_code(401); 
        throw new Exception('Invalid token: ' . $e->getMessage());
    }
}

?>
