<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Invalid request method');
    }

    $invoice_data = array();

    $query = "SELECT * FROM invoice_header";

    $query .= "  ORDER BY `inovideHID` DESC";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['client_id'];
            $client_invoiceid = $row['inovideHID'];

            $invoice_query = "SELECT * FROM `invoice_details` WHERE `invoice_HID` = $client_invoiceid AND `client_id` = $client_id";

            $invoice_result = mysqli_query($conn, $invoice_query);

            $invoice_details = array();

            $invoice_details = mysqli_fetch_assoc($invoice_result);

            $row['invoice_data'] = $invoice_details;

            //  client details
            $client_query = "SELECT f_name,l_name,email,mobile FROM `clients` WHERE `c_id` = $client_id";

            $client_result = mysqli_query($conn, $client_query);

            $client_row_count = mysqli_num_rows($client_result);

            if ($client_row_count = 1) {

                $client_row = mysqli_fetch_assoc($client_result);

                $client_data = $client_row;

                $row['client_details'] = $client_data;

            }

            $invoice_data[] = $row;
        }

        $response = array('success' => true, 'invoice' => $invoice_data, 'message' => 'Authentication successful');

    } else {
        // Authentication failed
        $response = array('success' => false, 'message' => 'invalid user id');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>