<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Invalid request method');
    }

    
    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];


    $query = "SELECT * FROM clients WHERE `status` = 0 AND `verification_status` = 1 ORDER BY `c_id` DESC";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {
        $client_data = array();

        while ($row = mysqli_fetch_assoc($result)) {
            // Fetch sender data for each client
            $client_id = $row['c_id'];
            $sender_query = "SELECT sender_id FROM `sender_details` WHERE `client_id` = $client_id AND `status` = 'Active' AND `adminStatus` = 'approved'";
            $sender_result = mysqli_query($conn, $sender_query);

            $sender_data = array();

            while ($sender_row = mysqli_fetch_assoc($sender_result)) {
                $sender_data[] = $sender_row;
            }

            // Combine client and sender data into one array
            $row['sender_data'] = $sender_data;
            $client_data[] = $row;
        }

        $response = array('success' => true, 'client' => $client_data, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>

