<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';


try {
    if($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Invalid request method');
    }

     
    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    $query = "SELECT * FROM users WHERE 1=1";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if($row_count > 0) {
        $user_data = array();
        while($row = mysqli_fetch_assoc($result)) {
            unset($row['password']);
            $user_data[] = $row;
        }

        $response = array('success' => true, 'user' => $user_data, 'message' => 'Authentication successful');

    } else {
        // Authentication failed
        $response = array('success' => false, 'message' => 'invalid user id');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>