<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    $json_data = file_get_contents('php://input');

    // Sanitize and decode the JSON data
    $data = json_decode($json_data, true);

    // Initialize variables
    $total_balance = 0;
    $adjustment_balance_total = 0;
    $adjustment_balance_count = 0;
    $cancel_invoice_count = 0;
    $total_demo = 0;

    // Function to execute count query
    function totalBalanceQuery($conn)
    {
        // $query = "SELECT SUM(current_balance) as total_pages
        // FROM clients";
        $query = "SELECT SUM(current_balance) as total
        FROM clients
        INNER JOIN (
            SELECT client_id, SUM(total) AS total_sum
            FROM invoice_details
            WHERE status = 'paid'
            GROUP BY client_id
        ) AS subquery ON clients.c_id = subquery.client_id";

        $result = mysqli_query($conn, $query);
        return $result ? floatval(mysqli_fetch_assoc($result)['total']) : 0;
    }

    // Function to execute demo query
    function totalDemoQuery($conn)
    {

        $query = "SELECT SUM(current_balance) as total
        FROM clients
        INNER JOIN (
            SELECT client_id, SUM(total) AS total_sum
            FROM invoice_details
            WHERE status = 'paid'
            GROUP BY client_id
        ) AS subquery ON clients.c_id = subquery.client_id";

        $result = mysqli_query($conn, $query);
        $productive_total = $result ? floatval(mysqli_fetch_assoc($result)['total']) : 0;

        $query_all = "SELECT SUM(current_balance) as total_pages FROM clients";

        $result_all = mysqli_query($conn, $query_all);
        $all_total = $result_all ? floatval(mysqli_fetch_assoc($result_all)['total_pages']) : 0;

        return $all_total - $productive_total;
    }

    // Function to execute adjustment balance
    function adjustmentBalanceQuery($conn)
    {
        $query = "SELECT SUM(cost) as total_amount
        FROM account_history
        WHERE `type` = 'balanceAdjustment' AND `campaign_id` IS NULL";

        $result = mysqli_query($conn, $query);
        return $result ? floatval(mysqli_fetch_assoc($result)['total_amount']) : 0;
    }


    // Function to execute adjustment balance count
    function adjustmentBalanceCount($conn)
    {
        $query = "SELECT Count(cost) as total_amount
        FROM account_history
        WHERE `type` = 'balanceAdjustment' AND `campaign_id` IS NULL";

        $result = mysqli_query($conn, $query);
        return $result ? intval(mysqli_fetch_assoc($result)['total_amount']) : 0;
    }


    // Function to execute cancel invoice count
    function cancelInvoiceCount($conn)
    {
        $query = "SELECT Count(*) as total_pages
        FROM invoice_details
        WHERE `status` = 'cancel'";

        $result = mysqli_query($conn, $query);
        return $result ? intval(mysqli_fetch_assoc($result)['total_pages']) : 0;
    }

    function PayhereAmount($conn)
    {
        $query = "SELECT client_id, SUM(total) AS total_sum FROM invoice_details WHERE status = 'paid' AND document IS NOT NULL";

        $result = mysqli_query($conn, $query);
        return $result ? intval(mysqli_fetch_assoc($result)['total_sum']) : 0;
    }

    function SlipAmount($conn)
    {
        $query = "SELECT client_id, SUM(total) AS total_sum FROM invoice_details WHERE status = 'paid' AND document IS NULL";

        $result = mysqli_query($conn, $query);
        return $result ? intval(mysqli_fetch_assoc($result)['total_sum']) : 0;
    }

    // Execute count queries
    $total_balance = totalBalanceQuery($conn);
    $adjustment_balance_total = adjustmentBalanceQuery($conn);
    $adjustment_balance_count = adjustmentBalanceCount($conn);
    $cancel_invoice_count = cancelInvoiceCount($conn);
    $total_demo = totalDemoQuery($conn);
    $payhere_amount = PayhereAmount($conn);
    $slip_amount = SlipAmount($conn);
    // Response
    echo json_encode(array('success' => true, 'total_balance' => $total_balance, 'demo_total' => $total_demo, 'adjustment_balance_total' => $adjustment_balance_total, 'adjustment_balance_count' => $adjustment_balance_count, 'cancel_invoice_count' => $cancel_invoice_count, 'payhere_amount' =>$payhere_amount, 'slip_amount' =>$slip_amount));

} catch (\Throwable $th) {
    echo json_encode(array('success' => false, 'message' => $th->getMessage()));
}
?>