<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];
    
    // Initialize variables
    $months_setupfee_total = [];
    $month_names = [];
    $months_topup_total = [];
    $months_senderID_total = [];
    $months_unpaid_setupfee_total = [];
    $months_unpaid_setupfee_count = [];

    // Function to execute count query
    function executeCountQuery($conn, $startOfMonth, $endOfMonth)
    {
        $query = "SELECT SUM(total) as total_pages
        FROM invoice_details
        WHERE Date(`date`) BETWEEN '$startOfMonth' AND '$endOfMonth' AND `description` = 'SMS Platform Set Up Fee' AND `status` = 'paid'";

        $result = mysqli_query($conn, $query);
        return $result ? floatval(mysqli_fetch_assoc($result)['total_pages']) : 0;
    }

    // Calculate dates and execute topup toatal
    function topupFeeQuery($conn, $startOfMonth, $endOfMonth)
    {
        $query = "SELECT SUM(total) as total
        FROM invoice_details
        WHERE Date(`date`) BETWEEN '$startOfMonth' AND '$endOfMonth' AND `description` = 'SMS Top-Up' AND  `status` = 'paid'";

        $result = mysqli_query($conn, $query);
        return $result ? floatval(mysqli_fetch_assoc($result)['total']) : 0;
    }

    // Calculate dates and execute senderID fee
    function senderIDFeeQuery($conn, $startOfMonth, $endOfMonth)
    {
        $query = "SELECT SUM(total) as total
        FROM invoice_details
        WHERE Date(`date`) BETWEEN '$startOfMonth' AND '$endOfMonth' AND `description` != 'SMS Top-Up' AND `description` != 'SMS Platform Set Up Fee' AND `status` = 'paid'";

        $result = mysqli_query($conn, $query);
        return $result ? floatval(mysqli_fetch_assoc($result)['total']) : 0;
    }

    // Calculate dates and execute unpaid setup fee
    function unpaidSetupFee($conn, $startOfMonth, $endOfMonth)
    {
        $query = "SELECT SUM(total) as total
        FROM invoice_details
        WHERE Date(`date`) BETWEEN '$startOfMonth' AND '$endOfMonth' AND `description` = 'SMS Platform Set Up Fee' AND `status` = 'unpaid'";

        $result = mysqli_query($conn, $query);
        return $result ? floatval(mysqli_fetch_assoc($result)['total']) : 0;
    }

    // Calculate dates and execute unpaid setup fee count
    function unpaidSetupcount($conn, $startOfMonth, $endOfMonth)
    {
        $query = "SELECT COUNT(invoice_DID) as total
       FROM invoice_details
       WHERE Date(`date`) BETWEEN '$startOfMonth' AND '$endOfMonth' AND `description` = 'SMS Platform Set Up Fee' AND `status` = 'unpaid'";

        $result = mysqli_query($conn, $query);
        return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
    }

    // Calculate dates and execute count queries for each month
    for ($i = 0; $i < 6; $i++) {
        $startOfMonth = date('Y-m-01', strtotime("-$i months"));
        $endOfMonth = date('Y-m-t', strtotime("-$i months"));

        // Execute setup fee for the month
        $month_setup_fee = executeCountQuery($conn, $startOfMonth, $endOfMonth);
        $months_setupfee_total[] = $month_setup_fee;

        // Execute the topup amount
        $month_topup_total = topupFeeQuery($conn, $startOfMonth, $endOfMonth);
        $months_topup_total[] = $month_topup_total;

        // Execute the senderid amount
        $month_senderid_total = senderIDFeeQuery($conn, $startOfMonth, $endOfMonth);
        $months_senderID_total[] = $month_senderid_total;

        // Execute unpaid setup fee for the month
        $month_unpaid_setup_count = unpaidSetupFee($conn, $startOfMonth, $endOfMonth);
        $months_unpaid_setupfee_total[] = $month_unpaid_setup_count;

        // Execute unpaid setup fee count for the month
        $month_unpaid_setup_fee = unpaidSetupcount($conn, $startOfMonth, $endOfMonth);
        $months_unpaid_setupfee_count[] = $month_unpaid_setup_fee;

        // Store the month name in the array
        $month_names[] = date('F', strtotime($startOfMonth));
    }

    // Response
    echo json_encode(array('success' => true, 'months_setupfee_total' => $months_setupfee_total, 'month_topup_total' => $months_topup_total, 'month_senderid_total' => $months_senderID_total, 'months_unpaid_setupfee_total' => $months_unpaid_setupfee_total, 'months_unpaid_setupfee_count' => $months_unpaid_setupfee_count, 'month_names' => $month_names));
} catch (\Throwable $th) {
    echo json_encode(array('success' => false, 'message' => $th->getMessage()));
}

?>