<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $email = isset($data['email']) ? mysqli_real_escape_string($conn, $data['email']) : null;
   
    // Update trans_per_msg and promocost in clients table
    $updateClientQuery = "UPDATE users SET `email_subscribe` = 0 WHERE `username` = '$email'";
    $updateClientResult = mysqli_query($conn, $updateClientQuery);

    $affectedRows = mysqli_affected_rows($conn); 

    if ($affectedRows > 0) {
        $response = array('success' => true, 'message' => 'Unsubscribe succesfully');
    } else {
        $response = array('success' => false, 'message' => 'Unsubscribe failed. Please try again.');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>