<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");



try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? intval($data['id']) : 0;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;

    $updateQuery = "UPDATE invoice_details SET `document` = Null WHERE `invoice_HID` = '$id'";
    $updateResult = mysqli_query($conn, $updateQuery);
    
    if($updateResult){
        $response = array('success' => true,  'message' => 'delete successfully');

            $by = $adminId;
            $date = date('Y-m-d H:i:s');
            $module = 'Update Topup';
            $message = "Administrator $adminId has successfully updated the document for invoice_details $id.";
    
            insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        $response = array('success' => false, 'message' => 'Failed to update Document');

    }
    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>