<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = explode('/', $uri);

$action = $uri[3];

try {
    // if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    //     throw new Exception('Invalid request method');
    // }

    // // Assuming your JSON data is sent in the request body
    // $json_data = file_get_contents('php://input');

    // // Decode the JSON data
    // $data = json_decode($json_data, true);

    if ($action === 'allclient') {
        $query = "SELECT COUNT(*) as total  FROM clients WHERE `status` = 1 AND `verification_status` = 1";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('total_clients' => $row_totalCount));

    } else if ($action === 'dayclient') {
        // Get the current date and time
        $currentDate = date('Y-m-d');

        // Build the query to count clients within the past 24 hours
        $query = "SELECT COUNT(*) as total FROM clients 
              WHERE `status` = 1 AND `verification_status` = 1
              AND Date(register_date) = '$currentDate'";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('total_clients' => $row_totalCount));

    } else if ($action === 'allsenderid') {

        $query = "SELECT COUNT(*) as total  FROM sender_details WHERE `status` = 'Active' AND `adminStatus` = 'approved'";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('total_senderid' => $row_totalCount));

    } else if ($action === 'daysenderid') {
        // Get the current date and time
        $currentDate = date('Y-m-d');

        // Build the query to count clients within the past 24 hours
        $query = "SELECT COUNT(*) as total FROM sender_details 
              WHERE `status` = 'Active' AND `adminStatus` = 'approved'
              AND Date(`date`) = '$currentDate'";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('total_senderid' => $row_totalCount));

    } else if ($action === 'daytranssmsdel') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE Date(logs.create_date) = '$currentDate' AND logs.status = '1' AND sender_details.type = 'transactional' AND logs.g_deliveryStatus = 2";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsdel' => $row_totalCount));


    } else if ($action === 'daytranssmsfail') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE Date(logs.create_date) = '$currentDate' AND logs.status = '1' AND sender_details.type = 'transactional' AND logs.g_deliveryStatus = 3";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsfail' => $row_totalCount));


    } else if ($action === 'daytranssmssent') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE Date(logs.create_date) = '$currentDate' AND logs.status = '1' AND sender_details.type = 'transactional' AND logs.g_deliveryStatus = 0";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmssent' => $row_totalCount));


    } else if ($action === 'daypromosmsdel') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE Date(logs.create_date) = '$currentDate' AND logs.status = '1' AND sender_details.type = 'promotional' AND logs.g_deliveryStatus = 2";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsdel' => $row_totalCount));


    } else if ($action === 'daypromosmsfail') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE Date(logs.create_date) = '$currentDate' AND logs.status = '1' AND sender_details.type = 'promotional' AND logs.g_deliveryStatus = 3";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsfail' => $row_totalCount));


    } else if ($action === 'daypromosmssent') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE Date(logs.create_date) = '$currentDate' AND logs.status = '1' AND sender_details.type = 'promotional' AND logs.g_deliveryStatus = 0";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmssent' => $row_totalCount));


    } else if ($action === 'dayapi') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE Date(logs.create_date) = '$currentDate' AND logs.status = '1' AND  logs.type IN ('apibulk', 'apiind')";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('dayapi' => $row_totalCount));


    } else if ($action === 'weektranssmsdel') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEARWEEK(logs.create_date) = YEARWEEK(CURDATE()) AND logs.status = '1' AND sender_details.type = 'transactional' AND logs.g_deliveryStatus = 2";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsdel' => $row_totalCount));


    } else if ($action === 'weektranssmsfail') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEARWEEK(logs.create_date) = YEARWEEK(CURDATE()) AND logs.status = '1' AND sender_details.type = 'transactional' AND logs.g_deliveryStatus = 3";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsfail' => $row_totalCount));


    } else if ($action === 'weektranssmssent') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEARWEEK(logs.create_date) = YEARWEEK(CURDATE()) AND logs.status = '1' AND sender_details.type = 'transactional' AND logs.g_deliveryStatus = 0";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmssent' => $row_totalCount));


    } else if ($action === 'weekpromosmsdel') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEARWEEK(logs.create_date) = YEARWEEK(CURDATE()) AND logs.status = '1' AND sender_details.type = 'promotional' AND logs.g_deliveryStatus = 2";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsdel' => $row_totalCount));


    } else if ($action === 'weekpromosmsfail') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEARWEEK(logs.create_date) = YEARWEEK(CURDATE()) AND logs.status = '1' AND sender_details.type = 'promotional' AND logs.g_deliveryStatus = 3";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsfail' => $row_totalCount));


    } else if ($action === 'weekpromosmssent') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEARWEEK(logs.create_date) = YEARWEEK(CURDATE()) AND logs.status = '1' AND sender_details.type = 'promotional' AND logs.g_deliveryStatus = 0";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmssent' => $row_totalCount));


    } else if ($action === 'weekapi') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEARWEEK(logs.create_date) = YEARWEEK(CURDATE()) AND logs.status = '1' AND  logs.type IN ('apibulk', 'apiind')";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('dayapi' => $row_totalCount));


    } else if ($action === 'weekclient') {

        $query = "SELECT COUNT(*) as total FROM clients 
              WHERE `status` = 1 AND `verification_status` = 1
              AND YEARWEEK(`register_date`) = YEARWEEK(CURDATE())";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('total_clients' => $row_totalCount));

    } else if ($action === 'weeksenderid') {

        $query = "SELECT COUNT(*) as total FROM sender_details 
          WHERE `status` = 'Active' AND `adminStatus` = 'approved'
          AND YEARWEEK(`date`) = YEARWEEK(CURDATE())";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('total_senderid' => $row_totalCount));

    } else if ($action === 'monthclient') {

        $query = "SELECT COUNT(*) as total FROM clients 
              WHERE `status` = 1 AND `verification_status` = 1
              AND YEAR(`register_date`) = YEAR(CURDATE())
          AND MONTH(`register_date`) = MONTH(CURDATE())";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('total_clients' => $row_totalCount));

    } else if ($action === 'monthsenderid') {

        $query = "SELECT COUNT(*) as total FROM sender_details 
          WHERE `status` = 'Active' AND `adminStatus` = 'approved'
          AND YEAR(`date`) = YEAR(CURDATE())
          AND MONTH(`date`) = MONTH(CURDATE())";


        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('total_senderid' => $row_totalCount));

    } else if ($action === 'monthtranssmsdel') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEAR(logs.create_date) = YEAR(CURDATE()) AND MONTH(logs.create_date) = MONTH(CURDATE()) AND logs.status = '1' AND sender_details.type = 'transactional' AND logs.g_deliveryStatus = 2";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsdel' => $row_totalCount));


    } else if ($action === 'monthtranssmsfail') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEAR(logs.create_date) = YEAR(CURDATE()) AND MONTH(logs.create_date) = MONTH(CURDATE()) AND logs.status = '1' AND sender_details.type = 'transactional' AND logs.g_deliveryStatus = 3";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsfail' => $row_totalCount));


    } else if ($action === 'monthtranssmssent') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEAR(logs.create_date) = YEAR(CURDATE()) AND MONTH(logs.create_date) = MONTH(CURDATE()) AND logs.status = '1' AND sender_details.type = 'transactional' AND logs.g_deliveryStatus = 0";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmssent' => $row_totalCount));


    } else if ($action === 'monthpromosmsdel') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEAR(logs.create_date) = YEAR(CURDATE()) AND MONTH(logs.create_date) = MONTH(CURDATE()) AND logs.status = '1' AND sender_details.type = 'promotional' AND logs.g_deliveryStatus = 2";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsdel' => $row_totalCount));


    } else if ($action === 'monthpromosmsfail') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEAR(logs.create_date) = YEAR(CURDATE()) AND MONTH(logs.create_date) = MONTH(CURDATE()) AND logs.status = '1' AND sender_details.type = 'promotional' AND logs.g_deliveryStatus = 3";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmsfail' => $row_totalCount));


    } else if ($action === 'monthpromosmssent') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEAR(logs.create_date) = YEAR(CURDATE()) AND MONTH(logs.create_date) = MONTH(CURDATE()) AND logs.status = '1' AND sender_details.type = 'promotional' AND logs.g_deliveryStatus = 0";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('daysmssent' => $row_totalCount));


    } else if ($action === 'monthapi') {
        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');

        // Build the query to count clients registered today
        $query = "SELECT SUM(page_count) as total_pages
        FROM logs
        INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
        WHERE YEAR(logs.create_date) = YEAR(CURDATE()) AND MONTH(logs.create_date) = MONTH(CURDATE()) AND logs.status = '1' AND  logs.type IN ('apibulk', 'apiind')";

        $result = mysqli_query($conn, $query);

        $row_totalCount = mysqli_fetch_assoc($result)['total_pages'];
        $row_totalCount = intval($row_totalCount);

        echo json_encode(array('dayapi' => $row_totalCount));


    } else if ($action === 'daysms') {
        $deliveredCount = array();
        $failedCount = array();
        $sentCount = array();
        $row_date = array();
        // Get the current date and time
        $currentDateTime = date('Y-m-d H:i:s');

        $query = "SELECT DATE(create_date) as create_date, 
                     SUM(page_count) as total_sent,
                     SUM(CASE WHEN logs.g_deliveryStatus = 3 THEN page_count ELSE 0 END) as total_failed,
                     SUM(CASE WHEN logs.g_deliveryStatus = 2 THEN page_count ELSE 0 END) as total_delivered
              FROM logs
              INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
              WHERE logs.create_date >= DATE_SUB('$currentDateTime', INTERVAL 7 DAY) AND logs.status = '1' AND sender_details.type = 'transactional'
              GROUP BY DATE(create_date)
              ORDER BY create_date";


        $result = mysqli_query($conn, $query);

        if ($result) {
            // Fetch the result as an associative array
            while ($row = mysqli_fetch_assoc($result)) {

                $sentCount[] = $row['total_sent'];
                $failedCount[] = $row['total_failed'];
                $deliveredCount[] = $row['total_delivered'];
                $row_date[] = $row['create_date'];

            }
            echo json_encode(array('sentsms' => $sentCount, 'failedsms' => $failedCount, 'deliveredsms' => $deliveredCount, 'Date' => $row_date));

        } else {
            // Handle the case where the query fails
            echo "Error executing query: " . mysqli_error($conn);
        }

    } else if ($action === 'weeklysms') {
        $deliveredCount = array();
        $failedCount = array();
        $sentCount = array();
        $row_date = array();
        // Get the current date and time
        $currentDateTime = date('Y-m-d H:i:s');

        $query = "SELECT CONCAT(MIN(DATE(create_date)), ' - ', MAX(DATE(create_date))) as create_date, 
                     SUM(page_count) as total_sent,
                     SUM(CASE WHEN logs.g_deliveryStatus = 3 THEN page_count ELSE 0 END) as total_failed,
                     SUM(CASE WHEN logs.g_deliveryStatus = 2 THEN page_count ELSE 0 END) as total_delivered
              FROM logs
              INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
              WHERE logs.create_date >= DATE_SUB('$currentDateTime', INTERVAL 7 WEEK) AND logs.status = '1' AND sender_details.type = 'transactional'
              GROUP BY YEARWEEK(create_date)
              ORDER BY create_date";

        // echo $query;
        $result = mysqli_query($conn, $query);

        if ($result) {
            // Fetch the result as an associative array
            while ($row = mysqli_fetch_assoc($result)) {

                $sentCount[] = $row['total_sent'];
                $failedCount[] = $row['total_failed'];
                $deliveredCount[] = $row['total_delivered'];
                $row_date[] = $row['create_date'];

            }
            echo json_encode(array('sentsms' => $sentCount, 'failedsms' => $failedCount, 'deliveredsms' => $deliveredCount, 'Date' => $row_date));

        } else {
            // Handle the case where the query fails
            echo "Error executing query: " . mysqli_error($conn);
        }

    } else if ($action === 'monthlysms') {
        $deliveredCount = array();
        $failedCount = array();
        $sentCount = array();
        $row_date = array();
        // Get the current date and time
        $currentDateTime = date('Y-m-d H:i:s');

        $query = " SELECT DATE_FORMAT(MIN(create_date), '%M %Y') as create_date,
        SUM(page_count) as total_sent,
        SUM(CASE WHEN logs.g_deliveryStatus=3 THEN page_count ELSE 0 END) as total_failed,
        SUM(CASE WHEN logs.g_deliveryStatus=2 THEN page_count ELSE 0 END) as total_delivered
        FROM logs
        INNER JOIN sender_details ON logs.sender_id=sender_details.sender_id AND logs.client_id=sender_details.client_id
        WHERE logs.create_date >= DATE_SUB('2024-01-18 10:55:07', INTERVAL 7 MONTH) AND logs.status='1' AND sender_details.type='transactional'
        GROUP BY DATE_FORMAT(create_date, '%Y-%m')
        ORDER BY create_date";


        // echo $query;
        $result = mysqli_query($conn, $query);

        if ($result) {
            // Fetch the result as an associative array
            while ($row = mysqli_fetch_assoc($result)) {

                $sentCount[] = $row['total_sent'];
                $failedCount[] = $row['total_failed'];
                $deliveredCount[] = $row['total_delivered'];
                $row_date[] = $row['create_date'];

            }
            echo json_encode(array('sentsms' => $sentCount, 'failedsms' => $failedCount, 'deliveredsms' => $deliveredCount, 'Date' => $row_date));

        } else {
            // Handle the case where the query fails
            echo "Error executing query: " . mysqli_error($conn);
        }

    } else if ($action === 'promdaysms') {
        $deliveredCount = array();
        $failedCount = array();
        $sentCount = array();
        $row_date = array();
        // Get the current date and time
        $currentDateTime = date('Y-m-d H:i:s');

        $query = "SELECT DATE(create_date) as create_date, 
                     SUM(page_count) as total_sent,
                     SUM(CASE WHEN logs.g_deliveryStatus = 3 THEN page_count ELSE 0 END) as total_failed,
                     SUM(CASE WHEN logs.g_deliveryStatus = 2 THEN page_count ELSE 0 END) as total_delivered
              FROM logs
              INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
              WHERE logs.create_date >= DATE_SUB('$currentDateTime', INTERVAL 7 DAY) AND logs.status = '1' AND sender_details.type = 'promotional'
              GROUP BY DATE(create_date)
              ORDER BY create_date";


        $result = mysqli_query($conn, $query);

        if ($result) {
            // Fetch the result as an associative array
            while ($row = mysqli_fetch_assoc($result)) {

                $sentCount[] = $row['total_sent'];
                $failedCount[] = $row['total_failed'];
                $deliveredCount[] = $row['total_delivered'];
                $row_date[] = $row['create_date'];

            }
            echo json_encode(array('sentsms' => $sentCount, 'failedsms' => $failedCount, 'deliveredsms' => $deliveredCount, 'Date' => $row_date));

        } else {
            // Handle the case where the query fails
            echo "Error executing query: " . mysqli_error($conn);
        }

    } else if ($action === 'promweeklysms') {
        $deliveredCount = array();
        $failedCount = array();
        $sentCount = array();
        $row_date = array();
        // Get the current date and time
        $currentDateTime = date('Y-m-d H:i:s');

        $query = "SELECT CONCAT(MIN(DATE(create_date)), ' - ', MAX(DATE(create_date))) as create_date, 
                     SUM(page_count) as total_sent,
                     SUM(CASE WHEN logs.g_deliveryStatus = 3 THEN page_count ELSE 0 END) as total_failed,
                     SUM(CASE WHEN logs.g_deliveryStatus = 2 THEN page_count ELSE 0 END) as total_delivered
              FROM logs
              INNER JOIN sender_details ON logs.sender_id = sender_details.sender_id AND logs.client_id = sender_details.client_id 
              WHERE logs.create_date >= DATE_SUB('$currentDateTime', INTERVAL 7 WEEK) AND logs.status = '1' AND sender_details.type = 'promotional'
              GROUP BY YEARWEEK(create_date)
              ORDER BY create_date";

        // echo $query;
        $result = mysqli_query($conn, $query);

        if ($result) {
            // Fetch the result as an associative array
            while ($row = mysqli_fetch_assoc($result)) {

                $sentCount[] = $row['total_sent'];
                $failedCount[] = $row['total_failed'];
                $deliveredCount[] = $row['total_delivered'];
                $row_date[] = $row['create_date'];

            }
            echo json_encode(array('sentsms' => $sentCount, 'failedsms' => $failedCount, 'deliveredsms' => $deliveredCount, 'Date' => $row_date));

        } else {
            // Handle the case where the query fails
            echo "Error executing query: " . mysqli_error($conn);
        }

    } else if ($action === 'prommonthlysms') {
        $deliveredCount = array();
        $failedCount = array();
        $sentCount = array();
        $row_date = array();
        // Get the current date and time
        $currentDateTime = date('Y-m-d H:i:s');

        $query = " SELECT DATE_FORMAT(MIN(create_date), '%M %Y') as create_date,
        SUM(page_count) as total_sent,
        SUM(CASE WHEN logs.g_deliveryStatus=3 THEN page_count ELSE 0 END) as total_failed,
        SUM(CASE WHEN logs.g_deliveryStatus=2 THEN page_count ELSE 0 END) as total_delivered
        FROM logs
        INNER JOIN sender_details ON logs.sender_id=sender_details.sender_id AND logs.client_id=sender_details.client_id
        WHERE logs.create_date >= DATE_SUB('2024-01-18 10:55:07', INTERVAL 7 MONTH) AND logs.status='1' AND sender_details.type='promotional'
        GROUP BY DATE_FORMAT(create_date, '%Y-%m')
        ORDER BY create_date";


        // echo $query;
        $result = mysqli_query($conn, $query);

        if ($result) {
            // Fetch the result as an associative array
            while ($row = mysqli_fetch_assoc($result)) {

                $sentCount[] = $row['total_sent'];
                $failedCount[] = $row['total_failed'];
                $deliveredCount[] = $row['total_delivered'];
                $row_date[] = $row['create_date'];

            }
            echo json_encode(array('sentsms' => $sentCount, 'failedsms' => $failedCount, 'deliveredsms' => $deliveredCount, 'Date' => $row_date));

        } else {
            // Handle the case where the query fails
            echo "Error executing query: " . mysqli_error($conn);
        }

    } else if ($action === 'dayinvoice') {

        // Get today's date in the format YYYY-MM-DD
        $currentDate = date('Y-m-d');
    
        // Build the query to count clients registered today
        $query = "SELECT Count(*) as total FROM invoice_details WHERE Date(`date`) = '$currentDate'";
        $result = mysqli_query($conn, $query);
    
        if ($result) {
            $row_totalCount = mysqli_fetch_assoc($result)['total'];
            $row_totalCount = intval($row_totalCount);
        } else {
            $row_totalCount = 0; // Default to 0 if query fails
        }
    
        // Build the query to count paid invoices registered today
        $paid_query = "SELECT Count(*) as paidtotal FROM invoice_details WHERE Date(`date`) = '$currentDate' AND `status` = 'paid'";
        $paid_result = mysqli_query($conn, $paid_query);
    
        if ($paid_result) {
            $row_paidCount = mysqli_fetch_assoc($paid_result)['paidtotal'];
            $row_paidCount = intval($row_paidCount);
        } else {
            $row_paidCount = 0; // Default to 0 if query fails
        }
    
        // Return the results as a JSON object
        echo json_encode(array('total' => $row_totalCount, 'paidtotal' => $row_paidCount));

    } else if ($action === 'weekinvoice') {
    
        // Build the query to count clients registered today
        $query = "SELECT Count(*) as total FROM invoice_details WHERE YEARWEEK(`date`) = YEARWEEK(CURDATE())";
        $result = mysqli_query($conn, $query);
    
        if ($result) {
            $row_totalCount = mysqli_fetch_assoc($result)['total'];
            $row_totalCount = intval($row_totalCount);
        } else {
            $row_totalCount = 0; // Default to 0 if query fails
        }
    
        // Build the query to count paid invoices registered today
        $paid_query = "SELECT Count(*) as paidtotal FROM invoice_details WHERE YEARWEEK(`date`) = YEARWEEK(CURDATE()) AND `status` = 'paid'";
        $paid_result = mysqli_query($conn, $paid_query);
    
        if ($paid_result) {
            $row_paidCount = mysqli_fetch_assoc($paid_result)['paidtotal'];
            $row_paidCount = intval($row_paidCount);
        } else {
            $row_paidCount = 0; // Default to 0 if query fails
        }
    
        // Return the results as a JSON object
        echo json_encode(array('total' => $row_totalCount, 'paidtotal' => $row_paidCount));

    } else if ($action === 'monthlyinvoice') {
    
        // Build the query to count clients registered today
        $query = "SELECT Count(*) as total FROM invoice_details WHERE YEAR(`date`) = YEAR(CURDATE()) AND MONTH(`date`) = MONTH(CURDATE())";
        $result = mysqli_query($conn, $query);
    
        if ($result) {
            $row_totalCount = mysqli_fetch_assoc($result)['total'];
            $row_totalCount = intval($row_totalCount);
        } else {
            $row_totalCount = 0; // Default to 0 if query fails
        }
    
        // Build the query to count paid invoices registered today
        $paid_query = "SELECT Count(*) as paidtotal FROM invoice_details WHERE  YEAR(`date`) = YEAR(CURDATE()) AND MONTH(`date`) = MONTH(CURDATE()) AND `status` = 'paid'";
        $paid_result = mysqli_query($conn, $paid_query);
    
        if ($paid_result) {
            $row_paidCount = mysqli_fetch_assoc($paid_result)['paidtotal'];
            $row_paidCount = intval($row_paidCount);
        } else {
            $row_paidCount = 0; // Default to 0 if query fails
        }
    
        // Return the results as a JSON object
        echo json_encode(array('total' => $row_totalCount, 'paidtotal' => $row_paidCount));
    }
    
    

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>