<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/x-www-form-urlencoded; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");

try {
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    
    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $total = isset($data['total']) ? mysqli_real_escape_string($conn, $data['total']) : null;


    $query = "SELECT * FROM clients WHERE `c_id` = $id ";
    
    $result = mysqli_query($conn, $query);

    if (!$result) {
        throw new Exception('there is no user');
    }

    $row = mysqli_fetch_assoc($result);

    $company_name = $row['company_name'];

    $date = date('Y-m-d H:i:s');
    
    $i_header_query = "INSERT INTO invoice_header (`client_id`, `company_name`) VALUES ('$id', '$company_name')";

    $i_header_result = mysqli_query($conn, $i_header_query);

    if(!$i_header_result){
        throw new Exception("header query wrong");
    }

    $last_inserted_header_id = mysqli_insert_id($conn);

    $i_details_query = "INSERT INTO invoice_details (`invoice_HID`, `description`, `status`, `date`, `total`, `client_id`) VALUES ('$last_inserted_header_id', 'SMS Top-Up', 'unpaid', '$date', '$total', '$id')";

    $i_details_result = mysqli_query($conn, $i_details_query);

     // Retrieve details from invoice_details table
     $retrieve_details_query = "SELECT * FROM invoice_details WHERE `invoice_HID` = ?";
     $retrieve_details_stmt = mysqli_prepare($conn, $retrieve_details_query);
     mysqli_stmt_bind_param($retrieve_details_stmt, 'i', $last_inserted_header_id);
     mysqli_stmt_execute($retrieve_details_stmt);
 
     $details_result = mysqli_stmt_get_result($retrieve_details_stmt);

     if(!$details_result) {
        throw new Exception('deatils query wrong');
        
     }

    $details_row = mysqli_fetch_assoc($details_result) ;
     
    $sys_query = "SELECT * FROM system_setting";

    $sys_result = mysqli_query($conn, $sys_query);

    if (!$sys_result) {
        throw new Exception('sys query wrong');
    }

    $sys_data = mysqli_fetch_assoc($sys_result);

    $precentage = $sys_data['gateway_presentage'];
    $fixed_amount = $sys_data['gateway_fixed'];
    $fee = ($total * $precentage)/100 + $fixed_amount;

    $response = array('success' => true, 'message' => 'Invoice details inserted successfully', 'details' => $details_row, 'system' => $sys_data, 'client' => $row, 'fee' => $fee);
    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>