<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("adminlogs/admin_logs.php");
include ("notification/client_notification.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';


$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = explode('/', $uri);

$action = $uri[3];

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    if ($action === 'inactive') {

        // Assuming your JSON data is sent in the request body
        $json_data = file_get_contents('php://input');

        // Decode the JSON data
        $data = json_decode($json_data, true);

        $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
        $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;

        $query = "UPDATE `groups` SET `status`='inactive' WHERE g_id = $id ";

        $result = mysqli_query($conn, $query);

        if ($result) {
            $response = array('success' => true, 'message' => 'changed status successfully');

            // admin login
            $by = $userId;
            $date = date('Y-m-d H:i:s');
            $module = 'Inactive contact';
            $message = "Administrator $userId has successfully changed status to inactive for contact $id.";

            insertAdminLog($conn, $by, $date, $module, $message);

            // notification
            $title = 'Changed status';
            $date = date('Y-m-d H:i:s');
            $subtitle = ".Changed contact ($id) status to inactive";
            $avatar = 'CS';
            $client_id = $id;

            insertNotification($conn, $title, $date, $subtitle, $avatar, $client_id);

        } else {
            $response = array('success' => false, 'message' => 'Failed to update status');
        }
        echo json_encode($response);

    } else if ($action === 'active') {

        // Assuming your JSON data is sent in the request body
        $json_data = file_get_contents('php://input');

        // Decode the JSON data
        $data = json_decode($json_data, true);

        $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
        $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;

        $query = "UPDATE `groups` SET `status`='active' WHERE g_id = $id";

        $result = mysqli_query($conn, $query);

        if ($result) {
            $response = array('success' => true, 'message' => 'changed status successfully');

            // admin login
            $by = $adminId;
            $date = date('Y-m-d H:i:s');
            $module = 'Active contact';
            $message = "Administrator $adminId has successfully changed status to active for contact $id.";

            insertAdminLog($conn, $by, $date, $module, $message);

            // notification
            $title = 'Changed status';
            $date = date('Y-m-d H:i:s');
            $subtitle = ".Changed contact ($id) status to active";
            $avatar = 'CS';
            $client_id = $id;

            insertNotification($conn, $title, $date, $subtitle, $avatar, $client_id);

        } else {
            $response = array('success' => false, 'message' => 'Failed to update statust');
        }
        echo json_encode($response);

    }

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>