
<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $page = isset($data['page']) ? intval($data['page']) : 1;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $countQuery = "SELECT COUNT(*) as total FROM groups";
    $countResult = mysqli_query($conn, $countQuery);
    $row_totalCount = mysqli_fetch_assoc($countResult)['total'];

    $row_totalCount = intval($row_totalCount);

    $offset = ($page) * $pageSize;

    $query = "SELECT * FROM groups LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {
        $contact_data = array();

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['client_id'];

            $client_query = "SELECT f_name, l_name, email, mobile FROM `clients` WHERE `c_id` = $client_id";

            $client_result = mysqli_query($conn, $client_query);

            $client_row_count = mysqli_num_rows($client_result);

            if ($client_row_count == 1) {
                $client_data = mysqli_fetch_assoc($client_result);

                $row['client_details'] = $client_data;
                $contact_data[] = $row;
            }
        }

        $response = array('success' => true, 'contact' => $contact_data, 'total' => $row_totalCount,'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found');
    }

    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>
