<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';


function senderDetailsQuery($conn, $client_id)
{
    $query = "SELECT COUNT(*) as 'total'
        FROM sender_details WHERE client_id ='$client_id'";

    $result = mysqli_query($conn, $query);
    return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
}

function smsCountQuery($conn, $client_id)
{
    $query = "SELECT 
                SUM(CASE WHEN g_deliveryStatus = 2 THEN page_count ELSE 0 END) as 'delivered_total',
                SUM(CASE WHEN g_deliveryStatus = 3 THEN page_count ELSE 0 END) as 'failed_total',
                SUM(page_count) as 'total'
                FROM logs WHERE client_id ='$client_id'";

    $result = mysqli_query($conn, $query);
    return $result ? mysqli_fetch_assoc($result) : '';
}

function smsDateQuery($conn, $client_id)
{
    $query = "SELECT create_date FROM logs WHERE client_id ='$client_id' ORDER BY create_date DESC LIMIT 1";

    $result = mysqli_query($conn, $query);
    $row = ''; // Initialize $row with an empty value

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result)['create_date'];
    }

    return $row;
}

function productiveClientQuery($conn, $client_id)
{
    $query = "SELECT * FROM invoice_details WHERE client_id ='$client_id' AND `status` ='paid'";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {
        return true;
    } else {
        return false;
    }
}

function invoiceDetailsQuery($conn, $client_id)
{
    $query = "SELECT 
    SUM(`status` = 'paid') as 'paid_count',
    SUM(`status` = 'unpaid') as 'unpaid_count',
    SUM(CASE WHEN `status` = 'paid' THEN total ELSE 0 END) as 'total'
    FROM invoice_details WHERE client_id ='$client_id'";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {
        return mysqli_fetch_assoc($result);
    } else {
        return false;
    }
}

function loginQuery($conn, $client_id)
{
    $query = "SELECT `datetime` FROM user_log WHERE add_by ='$client_id' AND module = 'User Login' ORDER BY `datetime` DESC LIMIT 1";

    $result = mysqli_query($conn, $query);
    $row = ''; // Initialize $row with an empty value

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result)['datetime'];
    }

    return $row;
}

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $pClints = isset($data['pClints']) ? mysqli_real_escape_string($conn, $data['pClints']) : null;
    $orderType = isset($data['orderType']) ? mysqli_real_escape_string($conn, $data['orderType']) : 'ASC';
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $client_data = array();
    $row_totalCount = 0;

    $offset = ($page) * $pageSize;

    // calculate total row
    $countQuery = "SELECT COUNT(*) as total FROM clients WHERE 1=1 AND `status` = 1 AND `verification_status` = 1";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $countQuery .= " AND register_date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($pClints !== null && $pClints !== '') {
        $countQuery .= " AND productive_cli = '$pClints'";
    }

    $count_result = mysqli_query($conn, $countQuery);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }

    // .........................................................................
    $query = "SELECT * FROM clients WHERE 1=1 AND `status` = 1 AND `verification_status` = 1";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND register_date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($pClints !== null && $pClints !== '') {
        $query .= " AND productive_cli = '$pClints'";
    }

    $query .= " ORDER BY c_id DESC";

    $query .= " LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['c_id'];

            // sender details
            $senderid_count = senderDetailsQuery($conn, $client_id);
            $row['sender_details'] = $senderid_count;

            // logs details(sms)
            $sms_count = smsCountQuery($conn, $client_id);
            $row['sms_count'] = $sms_count;

            // last sms date
            $sms_date = smsDateQuery($conn, $client_id);
            $row['sms_date'] = $sms_date;

            // prductive_client check
            $productive_client = productiveClientQuery($conn, $client_id);
            $row['productive_client'] = $productive_client;

            // invoice
            $invoice_details = invoiceDetailsQuery($conn, $client_id);
            $row['invoice_details'] = $invoice_details;

            // login time
            $login_time = loginQuery($conn, $client_id);
            $row['login_time'] = $login_time;


            $client_data[] = $row;

        }

    }


    if (!empty($client_data)) {
        $response = array('success' => true, 'client' => $client_data, 'total' => $row_totalCount, 'message' => 'All the client details');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>