<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    

    $query = "SELECT * FROM invoice_header WHERE `client_id` = '$id'";

    $query .= "  ORDER BY `inovideHID` DESC";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {
        $invoice_data = array();

        while($row = mysqli_fetch_assoc($result)){
            $client_id = $row['client_id'];
            $client_invoiceid = $row['inovideHID'];

            $invoice_query = "SELECT * FROM `invoice_details` WHERE `invoice_HID` = $client_invoiceid AND `client_id` = $client_id";

            $invoice_result = mysqli_query($conn, $invoice_query);

            $invoice_details = array();

            $invoice_details = mysqli_fetch_assoc($invoice_result);

            $row['invoice_data'] = $invoice_details;
            $invoice_data[] = $row;
        }

        $response = array('success' => true, 'invoice' => $invoice_data, 'message' => 'Authentication successful');
        
    } else {
        // Authentication failed
        $response = array('success' => false, 'message' => 'invalid user id');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>