<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("notification/client_notification.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';
include("sendemail/sendMail.php");
include("allmails/allMail.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $invoiceid = isset($data['invoiceid']) ? mysqli_real_escape_string($conn, $data['invoiceid']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;
    $amount = isset($data['amount']) ? mysqli_real_escape_string($conn, $data['amount']) : null;
    $message = isset($data['message']) ? mysqli_real_escape_string($conn, $data['message']) : null;


    // Select the current balance
    $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$id'";
    $selectResult = mysqli_query($conn, $selectQuery);

    $row_count = mysqli_num_rows($selectResult);

    if ($row_count < 1) {
        throw new Exception('INo client found');
    }

    $client_data = mysqli_fetch_assoc($selectResult);

    // Update the current balance
    $currentBalance = $client_data['current_balance'];
    $updatedBalance = $currentBalance - $amount;

    $date = date('Y-m-d H:i:s');

    // Update the status to "cancel"
    $updateStatusQuery = "UPDATE invoice_details SET `status` = 'cancel', `reason` = '$message' WHERE `client_id` = '$id' AND `invoice_HID` = '$invoiceid'";
    $updateStatusResult = mysqli_query($conn, $updateStatusQuery);

    $updateQuery = "UPDATE clients SET `current_balance` = '$updatedBalance', low_bal_status = 0 WHERE `c_id` = '$id'";
    $updateResult = mysqli_query($conn, $updateQuery);


    $addTopupquery = "INSERT INTO topup_history (`datetime`, `current_balance`, `new_balance`, `topup`, `user_id`, `by`) VALUES ('$date', '$currentBalance', '$updatedBalance', '$amount', '$id', '0')";

    $addTopupresult = mysqli_query($conn, $addTopupquery);

    $accountquery = "INSERT INTO account_history (`datetime`, `current_balance`, `new_balance`, `cost`, `type`, `byID`, `whose`) VALUES ('$date', '$currentBalance', '$updatedBalance', '$amount', 'topUpReverse', '$id', '$id')";

    $resultAccount = mysqli_query($conn, $accountquery);


    if ($updateStatusResult && $updateResult && $addTopupresult && $resultAccount) {
        // Select the client 
        $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$id'";
        $selectResult = mysqli_query($conn, $selectQuery);

        $row_count = mysqli_num_rows($selectResult);
        if ($row_count < 1) {
            throw new Exception('Client not found');
        }

        $client_data = mysqli_fetch_assoc($selectResult);

        $c_mail = $client_data["email"];
        $client_name = $client_data["f_name"] . " " . $client_data["l_name"];
        $company_name = $client_data["company_name"];
        $c_mobile = $client_data["mobile"];

        // get invoice details
        $query_invoice = "SELECT * FROM invoice_details WHERE invoice_HID = '$invoiceid'";

        $result_invoice = mysqli_query($conn, $query_invoice);

        if (mysqli_num_rows($result_invoice) > 0) {

            $row_invoice = mysqli_fetch_assoc($result_invoice);

            $total = $row_invoice['total'];
            $date = $row_invoice['date'];
            $description = $row_invoice['description'];


            $query_system = "SELECT * FROM system_setting";

            $result_system = mysqli_query($conn, $query_system);

            if (mysqli_num_rows($result_system) > 0) {
                $row_system = mysqli_fetch_assoc($result_system);
                //pass row-system to email

                $mailCont = cancelPaidInvoiceTopup($invoiceid, $date, $total, $row_system, $client_name, $c_mail, $company_name, $c_mobile, $description,  $currentBalance, $amount, $updatedBalance);

                $postFileds = [
                    'to' => $c_mail, // Recipient's email address
                    'sub' => "Invoice Cancellation and SMS Top-Up Reversal - Invoice $invoiceid", // Email subject
                    'msg' => $mailCont, // HTML content of the email
                    'from' => 'billing@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
                ];

                $sms_details = sendMail($postFileds);

                $sms_details_array = json_decode($sms_details, true);

                $status_code = $sms_details_array['response']['ErrorCode'];
                $msg_id = $sms_details_array['response']['MessageID'];

                $response = array('success' => true, 'message' => 'Status updated to cancel successfully');

                // admin logs
                $by = $userId;
                $date = date('Y-m-d H:i:s');
                $module = 'Cancel Invoice';
                $message = "Administrator $userId has canceled invoice $invoiceid.";

                insertAdminLog($conn, $by, $date, $module, $message);

                // notification
                $title = 'Cancel Invoice';
                $date = date('Y-m-d H:i:s');
                $subtitle = "Canceled invoice $invoiceid.";
                $avatar = 'CI';
                $client_id = $id;

                insertNotification($conn, $title, $date, $subtitle, $avatar, $client_id);
            } else {
                throw new Exception("system data not found");
            }
        } else {
            throw new Exception("invoices not found");
        }
    } else {
        $response = array('success' => false, 'message' => 'Failed to update status to cancel');
    }

    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
