<?php

header('Access-Control-Allow-Origin: https://smsadmin.ozonesender.com');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';


try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

     
    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];
    
    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $searchany = isset($data['searchany']) ? mysqli_real_escape_string($conn, $data['searchany']) : null;


    $query = "SELECT * FROM users WHERE 1=1";

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND `user_id` = '$c_id'";
    }

    if ($searchany !== null && $searchany !== '') {
        $query .= " AND (user_id = '$searchany' OR username = '$searchany')";
    }

    $query .= "  ORDER BY `user_id` DESC";


    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {
        $user_data = array();

        while ($row = mysqli_fetch_assoc($result)) {
            unset($row['password']);
            $role = $row['role_id'];

            $role_query = "SELECT `role` FROM user_role WHERE id = '$role'";
            $role_result = mysqli_query($conn, $role_query);

            if ($role_result) {
                $role_row = mysqli_fetch_assoc($role_result);
                $row['role'] = $role_row;
            }

            $user_permission = json_decode($row["permission"]);
            $row["permission"] = $user_permission;

            $user_data[] = $row;

        }

        $response = array('success' => true, 'user' => $user_data, 'message' => 'Authentication successful');

    } else {
        // Authentication failed
        $response = array('success' => false, 'message' => 'invalid user id');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>