<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $value = isset($data['value']) ? mysqli_real_escape_string($conn, $data['value']) : null;
    $doc = isset($data['doc']) ? $data['doc'] : null;
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $invoice_data = array();
    $row_totalCount = 0;

    $offset = ($page) * $pageSize;

    $count_query = "SELECT COUNT(*) as total  FROM invoice_header
    INNER JOIN invoice_details ON invoice_header.inovideHID = invoice_details.invoice_HID
    WHERE invoice_details.status ='unpaid' ";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $count_query .= " AND invoice_details.date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($value !== null && $value !== '') {
        $count_query .= " AND (invoice_details.invoice_HID = '$value' OR invoice_details.description LIKE '%$value%')";
    }

    if ($c_id !== null && $c_id !== '') {
        $count_query .= " AND invoice_header.client_id = '$c_id'";
    }

    if ($doc !== null && $doc !== '') {
        if ($doc) {
            $count_query .= " AND invoice_details.document IS NOT NULL";
        } else {
            $count_query .= " AND invoice_details.document IS NULL";
        }
    }

    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }
    // .........................................................................................................

    // Fetch clients without considering 

    $query = "SELECT invoice_header.* FROM invoice_header
        INNER JOIN invoice_details ON invoice_header.inovideHID = invoice_details.invoice_HID
        WHERE invoice_details.status ='paid' ";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND invoice_details.date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($value !== null && $value !== '') {
        $query .= " AND (invoice_details.invoice_HID = '$value' OR invoice_details.description LIKE '%$value%')";
    }

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND invoice_header.client_id = '$c_id'";
    }

    if ($doc !== null && $doc !== '') {
        if ($doc) {
            $query .= " AND invoice_details.document IS NOT NULL";
        } else {
            $query .= " AND invoice_details.document IS NULL";
        }
    }

    $query .= "  ORDER BY `date` DESC";

    $query .= " LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['client_id'];
            $client_invoiceid = $row['inovideHID'];

            $invoice_query = "SELECT * FROM `invoice_details` WHERE `invoice_HID` = $client_invoiceid AND `client_id` = $client_id";

            $invoice_result = mysqli_query($conn, $invoice_query);

            $invoice_details = array();

            $invoice_details = mysqli_fetch_assoc($invoice_result);

            $row['invoice_data'] = $invoice_details;

            //  client details
            $client_query = "SELECT f_name,l_name,email,mobile,company_name FROM `clients` WHERE `c_id` = $client_id";

            $client_result = mysqli_query($conn, $client_query);

            $client_row_count = mysqli_num_rows($client_result);

            if ($client_row_count == 1) {

                $client_row = mysqli_fetch_assoc($client_result);

                $client_data = $client_row;

                $row['client_details'] = $client_data;

            }

            $invoice_data[] = $row;
        }

    }


    if (!empty($invoice_data)) {
        $response = array('success' => true, 'invoice' => $invoice_data, 'total' => $row_totalCount, 'message' => 'invoice found within the date range');
    } else {
        $response = array('success' => false, 'message' => 'No invoice found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>