<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    // Select the current balance
    $query = "SELECT * FROM admin_notification ORDER BY `date` DESC";
    $result = mysqli_query($conn, $query);

    if ($result) {
        $notifications = array();
        while ($row = mysqli_fetch_assoc($result)) {
            $notifications[] = $row;
        }
        $response = array('success' => true, 'message' => 'Data retrieved successfully', 'notification' => $notifications);
    } else {
        $response = array('success' => false, 'message' => 'Failed to retrieve data');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>
