<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    // $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;
    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $clientId = isset($data['clientId']) ? mysqli_real_escape_string($conn, $data['clientId']) : null;
    $message = isset($data['message']) ? mysqli_real_escape_string($conn, $data['message']) : null;


    $row_totalCount = 0;

    $admin_log = array();

    $offset = ($page) * $pageSize;


    $count_query = "SELECT COUNT(*) as total FROM admin_log WHERE 1=1";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $count_query .= " AND admin_log.date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($message !== '') {
        $count_query .= " AND `message` LIKE '%$message%'";
    }

    if ($clientId !== '') {
        $count_query .= " AND add_by = '$clientId'";
    }

    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }
    // .........................................................................................................
    $query = "SELECT * FROM admin_log WHERE 1=1";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND admin_log.date BETWEEN '$startDate' AND '$endDate'";
    }

    if ($message !== '') {
        $query .= " AND `message` LIKE '%$message%'";
    }

    if ($clientId !== '') {
        $query .= " AND add_by = '$clientId'";
    }


    $query .= "  ORDER BY `id` DESC";

    $query .= " LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['add_by'];

            $client_query = "SELECT f_name,l_name,user_id FROM `users` WHERE `user_id` = $client_id";

            $client_result = mysqli_query($conn, $client_query);

            if ($client_result) {
                $client_row = mysqli_fetch_assoc($client_result);
                $client_data = $client_row;

                $row['admin_details'] = $client_data;

                $admin_log[] = $row;
            }

        }

    }



    if (!empty($admin_log)) {
        $response = array('success' => true, 'log' => $admin_log, 'total' => $row_totalCount, 'message' => 'Authentication successful');

    } else {
        $response = array('success' => false, 'message' => 'invalid logs');

    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>