<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("adminlogs/admin_logs.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    // Assuming you have all the necessary fields in your frontend form
    $adminId = isset($data['adminId']) ? intval($data['adminId']) : 0;
    $firstName = isset($data['firstName']) ? mysqli_real_escape_string($conn, $data['firstName']) : '';
    $lastName = isset($data['lastName']) ? mysqli_real_escape_string($conn, $data['lastName']) : '';
    $email = isset($data['email']) ? mysqli_real_escape_string($conn, $data['email']) : '';
    $contact = isset($data['contact']) ? mysqli_real_escape_string($conn, $data['contact']) : '';
    $password = isset($data['password']) ? mysqli_real_escape_string($conn, $data['password']) : '';
    $role = isset($data['role']) ? mysqli_real_escape_string($conn, $data['role']) : '';
    $permission = isset($data['permission']) ? json_encode($data['permission']) : '[]';


    // Check if email already exists
    $emailCheckQuery = "SELECT * FROM users WHERE username = '$email'";
    $emailCheckResult = mysqli_query($conn, $emailCheckQuery);

    if (mysqli_num_rows($emailCheckResult) > 0) {
        throw new Exception('Email is already available');
    }

    $hashedNewPassword = password_hash($password, PASSWORD_DEFAULT);

    $query = "INSERT INTO users (`username`, `f_name`, `l_name`, `contact`, `password`, `role_id`, `permission`) VALUES ('$email', '$firstName', '$lastName', '$contact', '$hashedNewPassword', '$role', '$permission')";

    // Execute the update query
    $result = mysqli_query($conn, $query);

    if ($result) {
        $response = array('success' => true, 'message' => 'Created a user successfully', 'updated_data' => $data);

        $by = $userId;
        $date = date('Y-m-d H:i:s');
        $module = 'Create a user';
        $message = "Admin $userId Created a new user";

        insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        throw new Exception('Failed to create a user');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>