<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    $name = isset($data['name']) ? mysqli_real_escape_string($conn, $data['name']) : '';
    $transCost = isset($data['transCost']) ? mysqli_real_escape_string($conn, $data['transCost']) : '';
    $promCost = isset($data['promCost']) ? mysqli_real_escape_string($conn, $data['promCost']) : '';
    $msgLength = isset($data['msgLength']) ? mysqli_real_escape_string($conn, $data['msgLength']) : '';
    $note = isset($data['note']) ? mysqli_real_escape_string($conn, $data['note']) : '';

    $query = "INSERT INTO gateway (`route_name`, `t_cost`, `p_cost`, `opt_out_lenght`, `note`) VALUES ('$name', '$transCost', '$promCost', '$msgLength', '$note')";

    // Execute the update query
    $result = mysqli_query($conn, $query);

    if ($result) {
        $response = array('success' => true, 'message' => 'Created a user successfully');

            $by = $userId;
            $date = date('Y-m-d H:i:s');
            $module = 'Add a Route';
            $message = "Admin $userId add a route";
    
            insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        $response = array('success' => false, 'message' => 'Failed to create a user');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>